/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseColumnSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.InformationViewExceptionBase;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ColumnLookup
extends EntityLookup<DatabaseColumnSource> {
    private static final Logger log = LoggerFactory.getLogger(ColumnLookup.class);

    public ColumnLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "RelationalColumn");
    }

    @Override
    public EntityDetail lookupEntity(DatabaseColumnSource source) {
        EntityDetail columnEntity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.lookupBasedOnHierarchy(source));
        if (log.isDebugEnabled()) {
            log.debug("Column found [{}]", (Object)columnEntity);
        }
        return columnEntity;
    }

    public EntityDetail lookupBasedOnHierarchy(DatabaseColumnSource source) {
        Supplier<InformationViewExceptionBase> exceptionBaseSupplier = () -> ExceptionHandler.buildRetrieveEntityException("RelationalColumn", source.toString(), null, this.getClass().getName());
        EntityDetail entityDetail = Optional.ofNullable(this.parentChain.lookupEntity(source.getTableSource())).orElseThrow(exceptionBaseSupplier);
        return Optional.ofNullable(this.filterBasedOnMatchingProperties(source, entityDetail)).orElseThrow(exceptionBaseSupplier);
    }

    private EntityDetail filterBasedOnMatchingProperties(DatabaseColumnSource source, EntityDetail tableEntity) {
        List<EntityDetail> relatedEntities = this.omEntityDao.getRelatedEntities(Arrays.asList(tableEntity.getGUID()), "SchemaAttributeType", r -> r.getEntityTwoProxy().getGUID());
        if (!CollectionUtils.isEmpty(relatedEntities)) {
            List<EntityDetail> allColumns = this.omEntityDao.getRelatedEntities(relatedEntities.stream().map(InstanceHeader::getGUID).collect(Collectors.toList()), "AttributeForSchema", r -> r.getEntityTwoProxy().getGUID());
            return this.filterEntities(Arrays.asList("RelationalColumn", "DerivedRelationalColumn"), source, allColumns);
        }
        return null;
    }

    @Override
    protected InstanceProperties getMatchingProperties(DatabaseColumnSource source) {
        String methodName = "getMatchingProperties";
        String sourceNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getName());
        return this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("", new InstanceProperties(), "name", sourceNameRegex, methodName);
    }
}

