/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.utils;

import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPropertiesUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityPropertiesUtils.class);

    public static PrimitivePropertyValue createPrimitiveStringPropertyValue(String value) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        propertyValue.setPrimitiveValue((Object)value);
        propertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
        propertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        return propertyValue;
    }

    public static PrimitivePropertyValue createPrimitiveIntPropertyValue(Integer value) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        propertyValue.setPrimitiveValue((Object)value);
        propertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
        propertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
        return propertyValue;
    }

    public static PrimitivePropertyValue createPrimitiveDatePropertyValue(Long timestamp) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        propertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
        propertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
        propertyValue.setPrimitiveValue((Object)timestamp);
        return propertyValue;
    }

    public static boolean matchExactlyInstanceProperties(InstanceProperties properties1, InstanceProperties properties2) {
        if (properties1.getInstanceProperties().size() != properties2.getInstanceProperties().size()) {
            return false;
        }
        for (Map.Entry property : properties2.getInstanceProperties().entrySet()) {
            if (EntityPropertiesUtils.matchExactlyPropertiesValues((InstancePropertyValue)property.getValue(), properties1.getPropertyValue((String)property.getKey()))) continue;
            log.info("ElementProperties don't match");
            return false;
        }
        log.info("ElementProperties match");
        return true;
    }

    public static boolean matchExactlyPropertiesValues(InstancePropertyValue value1, InstancePropertyValue value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof PrimitivePropertyValue && value2 instanceof PrimitivePropertyValue && ((PrimitivePropertyValue)value1).getPrimitiveDefCategory() == ((PrimitivePropertyValue)value2).getPrimitiveDefCategory()) {
            Object primitiveValue1 = ((PrimitivePropertyValue)value1).getPrimitiveValue();
            Object primitiveValue2 = ((PrimitivePropertyValue)value2).getPrimitiveValue();
            if (primitiveValue1 == null && primitiveValue2 == null) {
                return true;
            }
            if (primitiveValue1 == null && primitiveValue2 != null) {
                return false;
            }
            return primitiveValue1.equals(primitiveValue2);
        }
        return false;
    }
}

