/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLookup
extends EntityLookup<DatabaseSource> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseLookup.class);

    public DatabaseLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "Database");
    }

    @Override
    public EntityDetail lookupEntity(DatabaseSource source) {
        EntityDetail databaseEntity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.lookupBasedOnHierarchy(source));
        if (log.isDebugEnabled()) {
            log.debug("Database found [{}]", (Object)databaseEntity);
        }
        return databaseEntity;
    }

    private EntityDetail lookupBasedOnHierarchy(DatabaseSource source) {
        EntityDetail optionalEndpointEntity = Optional.ofNullable(this.parentChain.lookupEntity(source.getEndpointSource())).orElseThrow(() -> ExceptionHandler.buildRetrieveEntityException("source", source.getEndpointSource().toString(), null, this.getClass().getName()));
        return Optional.ofNullable(this.filterBasedOnMatchingProperties(source, optionalEndpointEntity)).orElseThrow(() -> ExceptionHandler.buildRetrieveEntityException("source", source.toString(), null, this.getClass().getName()));
    }

    private EntityDetail filterBasedOnMatchingProperties(DatabaseSource source, EntityDetail endpointEntity) {
        List<EntityDetail> allConnection = this.omEntityDao.getRelatedEntities(Arrays.asList(endpointEntity.getGUID()), "ConnectionEndpoint", r -> r.getEntityTwoProxy().getGUID());
        List<EntityDetail> allLinkedDatabasesList = this.omEntityDao.getRelatedEntities(allConnection.stream().map(InstanceHeader::getGUID).collect(Collectors.toList()), "ConnectionToAsset", r -> r.getEntityTwoProxy().getGUID());
        return this.filterEntities(Arrays.asList("Database"), source, allLinkedDatabasesList);
    }

    @Override
    public void setParentChain(EntityLookup parentChain) {
        this.parentChain = parentChain;
    }

    @Override
    protected InstanceProperties getMatchingProperties(DatabaseSource source) {
        String sourceNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getName());
        InstanceProperties matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("", new InstanceProperties(), "name", sourceNameRegex, "findDEntity");
        return matchProperties;
    }
}

