/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.TableSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSchemaLookup
extends EntityLookup<TableSource> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSchemaLookup.class);

    public DatabaseSchemaLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "DeployedDatabaseSchema");
    }

    @Override
    public EntityDetail lookupEntity(TableSource source) {
        EntityDetail entity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.lookupBasedOnHierarchy(source));
        if (log.isDebugEnabled()) {
            log.debug("DatabaseSchema found [{}]", (Object)entity);
        }
        return entity;
    }

    private EntityDetail lookupBasedOnHierarchy(TableSource source) {
        Optional<EntityDetail> optional = Optional.ofNullable(this.parentChain.lookupEntity(source.getDatabaseSource()));
        return Optional.ofNullable(this.filterBasedOnMatchingProperties(source, optional)).orElseThrow(() -> ExceptionHandler.buildRetrieveEntityException("source", source.toString(), null, this.getClass().getName()));
    }

    private EntityDetail filterBasedOnMatchingProperties(TableSource source, Optional<EntityDetail> optional) {
        List<EntityDetail> allSchemas = this.omEntityDao.getRelatedEntities(Arrays.asList(optional.get().getGUID()), "DataContentForDataSet", e -> e.getEntityTwoProxy().getGUID());
        return this.filterEntities(Arrays.asList("DeployedDatabaseSchema", "InformationView"), source, allSchemas);
    }

    @Override
    protected InstanceProperties getMatchingProperties(TableSource source) {
        String sourceSchemaNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getSchemaName());
        return this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("", new InstanceProperties(), "name", sourceSchemaNameRegex, "findDatabase");
    }
}

