/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewRequestBody;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewBasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataViewCreator
extends DataViewBasicOperation {
    private static final Logger log = LoggerFactory.getLogger(DataViewCreator.class);

    protected DataViewCreator(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        super(omEntityDao, lookupHelper, helper, auditLog);
    }

    public void createDataView(String userId, DataViewRequestBody requestBody, EntityDetail dataViewEntity) {
        String methodName = "createDataView";
        String qualifiedNameForComplexSchemaType = QualifiedNameUtils.buildQualifiedName(requestBody.getDataView().getEndpointAddress(), "ComplexSchemaType", requestBody.getDataView().getId() + "_type");
        InstanceProperties complexSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForComplexSchemaType).build();
        OMEntityWrapper complexSchemaTypeEntityWrapper = this.omEntityDao.createOrUpdateExternalEntity(userId, "ComplexSchemaType", qualifiedNameForComplexSchemaType, requestBody.getRegistrationGuid(), requestBody.getRegistrationQualifiedName(), complexSchemaTypeProperties, null, false, false);
        log.debug("Created data view schema type {}", (Object)complexSchemaTypeEntityWrapper.getEntityDetail().getGUID());
        this.omEntityDao.addRelationship("AssetSchemaType", dataViewEntity.getGUID(), complexSchemaTypeEntityWrapper.getEntityDetail().getGUID(), new InstanceProperties());
        String qualifiedNameForDataView = this.helper.getStringProperty("InformationViewOmas", "qualifiedName", dataViewEntity.getProperties(), methodName);
        this.addElements(userId, qualifiedNameForDataView, complexSchemaTypeEntityWrapper.getEntityDetail().getGUID(), requestBody.getRegistrationGuid(), requestBody.getRegistrationQualifiedName(), requestBody.getDataView().getElements());
    }
}

