/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupBasedOnDataView;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupBasedOnDatabaseColumn;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupBasedOnReportColumn;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupStrategy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.springframework.util.StringUtils;

public class EntityReferenceResolver {
    private OMEntityDao omEntityDao;
    private Map<String, LookupStrategy> strategies = new HashMap<String, LookupStrategy>();
    private LookupBasedOnDatabaseColumn lookupBasedOnDatabaseColumn;
    private LookupBasedOnReportColumn lookupBasedOnReportColumn;
    private LookupBasedOnDataView lookupBasedOnDataView;

    public EntityReferenceResolver(LookupHelper lookupHelper, OMEntityDao omEntityDao) {
        this.lookupBasedOnDatabaseColumn = new LookupBasedOnDatabaseColumn(lookupHelper);
        this.lookupBasedOnReportColumn = new LookupBasedOnReportColumn(omEntityDao);
        this.lookupBasedOnDataView = new LookupBasedOnDataView(omEntityDao);
        this.omEntityDao = omEntityDao;
        this.buildStrategies();
    }

    private void buildStrategies() {
        this.strategies.put(DatabaseColumnSource.class.getName(), this.lookupBasedOnDatabaseColumn);
        this.strategies.put(ReportColumnSource.class.getName(), this.lookupBasedOnReportColumn);
        this.strategies.put(DataViewColumnSource.class.getName(), this.lookupBasedOnDataView);
    }

    public String resolveSourceGuid(Source source) {
        EntityDetail entity;
        if (source == null) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)source.getGuid())) {
            return source.getGuid();
        }
        if (!StringUtils.isEmpty((Object)source.getQualifiedName())) {
            return this.omEntityDao.getEntity(source.getClass().getName(), source.getQualifiedName(), false).getGUID();
        }
        LookupStrategy strategy = this.strategies.get(source.getClass().getName());
        if (strategy != null && (entity = strategy.lookup(source)) != null) {
            return entity.getGUID();
        }
        return null;
    }

    public String getBusinessTermGuid(BusinessTerm businessTerm) {
        if (businessTerm == null) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)businessTerm.getGuid())) {
            return businessTerm.getGuid();
        }
        if (!StringUtils.isEmpty((Object)businessTerm.getQualifiedName())) {
            EntityDetail entity = this.omEntityDao.getEntity("GlossaryTerm", businessTerm.getQualifiedName(), false);
            return entity.getGUID();
        }
        throw ExceptionHandler.buildRetrieveEntityException("guid", businessTerm.getGuid(), null, this.getClass().getName());
    }
}

