/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.server;

import org.odpi.openmetadata.accessservices.informationview.context.ContextBuilders;
import org.odpi.openmetadata.accessservices.informationview.registration.RegistrationHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportHandler;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewServicesInstanceMap;

public class InformationViewServicesInstance {
    private ReportHandler reportHandler;
    private DataViewHandler dataViewHandler;
    private ContextBuilders contextBuilders;
    private RegistrationHandler registrationHandler;
    private String serverName;

    public InformationViewServicesInstance(ReportHandler reportHandler, DataViewHandler dataViewHandler, RegistrationHandler registrationHandler, ContextBuilders contextBuilders, String serverName) {
        this.reportHandler = reportHandler;
        this.dataViewHandler = dataViewHandler;
        this.registrationHandler = registrationHandler;
        this.contextBuilders = contextBuilders;
        this.serverName = serverName;
        InformationViewServicesInstanceMap.setNewInstanceForJVM(serverName, this);
    }

    public ReportHandler getReportHandler() {
        return this.reportHandler;
    }

    public DataViewHandler getDataViewHandler() {
        return this.dataViewHandler;
    }

    public RegistrationHandler getRegistrationHandler() {
        return this.registrationHandler;
    }

    public ContextBuilders getContextBuilders() {
        return this.contextBuilders;
    }

    public void shutdown() {
        InformationViewServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

