/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.utils;

import org.springframework.util.StringUtils;

public class QualifiedNameUtils {
    public static final String SEPARATOR = "::";
    public static final String EQUALS = "=";
    public static final String OPEN_BRACKET = "(";
    public static final String CLOSE_BRACKET = ")";

    public static String buildQualifiedName(String parentQualifiedName, String typeName, String value) {
        if (!StringUtils.isEmpty((Object)parentQualifiedName)) {
            return parentQualifiedName + SEPARATOR + OPEN_BRACKET + typeName + CLOSE_BRACKET + EQUALS + value;
        }
        return OPEN_BRACKET + typeName + CLOSE_BRACKET + EQUALS + value;
    }

    public static String buildQualifiedNameForInformationView(String hostAddress, String databaseName, String schemaName) {
        String endpointQualifiedName = QualifiedNameUtils.buildQualifiedName("", "SoftwareServer", hostAddress);
        String databaseQualifiedName = QualifiedNameUtils.buildQualifiedName(endpointQualifiedName, "DataStoreProperties", databaseName);
        return QualifiedNameUtils.buildQualifiedName(databaseQualifiedName, "InformationView", schemaName);
    }

    public static String buildQualifiedNameForRelationalDbSchemaType(String hostAddress, String databaseName, String schemaName) {
        String endpointQualifiedName = QualifiedNameUtils.buildQualifiedName("", "SoftwareServer", hostAddress);
        String databaseQualifiedName = QualifiedNameUtils.buildQualifiedName(endpointQualifiedName, "DataStoreProperties", databaseName);
        return QualifiedNameUtils.buildQualifiedName(databaseQualifiedName, "RelationalDBSchemaType", schemaName + "_type");
    }

    public static String buildQualifiedNameForDataViewColumn(String hostAddress, String informationViewId, String columnName) {
        String endpointQualifiedName = "";
        if (!StringUtils.isEmpty((Object)hostAddress)) {
            endpointQualifiedName = QualifiedNameUtils.buildQualifiedName("", "SoftwareServer", hostAddress);
        }
        String informationViewQualifiedName = QualifiedNameUtils.buildQualifiedName(endpointQualifiedName, "InformationView", informationViewId);
        return QualifiedNameUtils.buildQualifiedName(informationViewQualifiedName, "DerivedSchemaAttributeProperties", columnName);
    }
}

