/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.DataViewCreationException;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewCreator;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewUpdater;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataViewHandler {
    private static final Logger log = LoggerFactory.getLogger(DataViewHandler.class);
    private OMEntityDao omEntityDao;
    private OMRSAuditLog auditLog;
    private DataViewCreator dataViewCreator;
    private DataViewUpdater dataViewUpdater;

    public DataViewHandler(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        this.omEntityDao = omEntityDao;
        this.dataViewCreator = new DataViewCreator(omEntityDao, lookupHelper, helper, auditLog);
        this.dataViewUpdater = new DataViewUpdater(omEntityDao, lookupHelper, helper, auditLog);
        this.auditLog = auditLog;
    }

    public String createDataView(String userId, DataViewRequestBody requestBody) throws DataViewCreationException {
        log.debug("Creating data view based on payload {}", (Object)requestBody);
        SoftwareServerCapabilitySource softwareServerCapabilitySource = this.dataViewCreator.retrieveSoftwareServerCapability(requestBody.getRegistrationGuid(), requestBody.getRegistrationQualifiedName());
        requestBody.setRegistrationGuid(softwareServerCapabilitySource.getGuid());
        requestBody.setRegistrationQualifiedName(softwareServerCapabilitySource.getQualifiedName());
        String qualifiedNameForDataView = QualifiedNameUtils.buildQualifiedName("", "InformationView", requestBody.getDataView().getId());
        InstanceProperties dataViewProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDataView).withStringProperty("name", requestBody.getDataView().getName()).withStringProperty("owner", requestBody.getDataView().getAuthor()).withStringProperty("id", requestBody.getDataView().getId()).withStringProperty("lastModifier", requestBody.getDataView().getLastModifier()).withDateProperty("lastModifiedTime", requestBody.getDataView().getLastModifiedTime()).withDateProperty("createdTime", requestBody.getDataView().getCreatedTime()).withStringProperty("nativeClass", requestBody.getDataView().getNativeClass()).build();
        OMEntityWrapper dataViewWrapper = this.omEntityDao.createOrUpdateExternalEntity(userId, "InformationView", qualifiedNameForDataView, requestBody.getRegistrationGuid(), requestBody.getRegistrationQualifiedName(), dataViewProperties, null, true, true);
        this.dataViewCreator.createDataView(userId, requestBody, dataViewWrapper.getEntityDetail());
        return dataViewWrapper.getEntityDetail().getGUID();
    }
}

