/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.server.spring;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.RegistrationRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.responses.InformationViewOMASAPIResponse;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewRestServices;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/information-view/users/{userId}/"})
@Validated
public class InformationViewOMASResource {
    private final InformationViewRestServices restAPI = new InformationViewRestServices();

    @PostMapping(path={"/report"})
    public InformationViewOMASAPIResponse submitReport(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @Valid @RequestBody ReportRequestBody requestBody) {
        return this.restAPI.submitReport(serverName, userId, requestBody);
    }

    @PostMapping(path={"/dataview"})
    public InformationViewOMASAPIResponse submitDataView(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody @Valid DataViewRequestBody requestBody) {
        return this.restAPI.submitDataView(serverName, userId, requestBody);
    }

    @GetMapping(path={"/databases"})
    public InformationViewOMASAPIResponse retrieveDatabases(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PositiveOrZero(message="startFrom should be a positive number") @RequestParam @PositiveOrZero(message="startFrom should be a positive number") Integer startFrom, @PositiveOrZero(message="pageSize should be a positive number") @RequestParam @PositiveOrZero(message="pageSize should be a positive number") Integer pageSize) {
        return this.restAPI.getDatabases(serverName, userId, startFrom.intValue(), pageSize.intValue());
    }

    @GetMapping(path={"databases/{database}/tables"})
    public InformationViewOMASAPIResponse retrieveTablesForDatabase(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @NotBlank(message="guid of the database should not be blank") @PathVariable(value="database") @NotBlank(message="guid of the database should not be blank") String databaseGuid, @PositiveOrZero(message="startFrom should be a positive number") @RequestParam @PositiveOrZero(message="startFrom should be a positive number") int startFrom, @PositiveOrZero(message="pageSize should be a positive number") @RequestParam @PositiveOrZero(message="pageSize should be a positive number") int pageSize) {
        return this.restAPI.getTablesForDatabase(serverName, userId, databaseGuid, startFrom, pageSize);
    }

    @GetMapping(path={"tables/{table}"})
    public InformationViewOMASAPIResponse retrieveTableContext(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @NotBlank(message="guid of the table should not be blank") @PathVariable(value="table") @NotBlank(message="guid of the table should not be blank") String tableGuid) {
        return this.restAPI.getTableContext(serverName, userId, tableGuid);
    }

    @GetMapping(path={"tables/{table}/columns"})
    public InformationViewOMASAPIResponse retrieveTableColumns(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @NotBlank(message="guid of the table should not be blank") @PathVariable(value="table") @NotBlank(message="guid of the table should not be blank") String tableGuid, @PositiveOrZero(message="startFrom should be a positive number") @RequestParam @PositiveOrZero(message="startFrom should be a positive number") Integer startFrom, @PositiveOrZero(message="pageSize should be a positive number") @RequestParam @PositiveOrZero(message="pageSize should be a positive number") Integer pageSize) {
        return this.restAPI.getTableColumns(serverName, userId, tableGuid, startFrom.intValue(), pageSize.intValue());
    }

    @PostMapping(path={"register"})
    public InformationViewOMASAPIResponse registerExternalTool(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @Valid @RequestBody RegistrationRequestBody requestBody) {
        return this.restAPI.registerExternalTool(serverName, userId, requestBody);
    }

    @PostMapping(path={"registration/lookup"})
    public InformationViewOMASAPIResponse lookupExternalTool(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @Valid @RequestBody RegistrationRequestBody requestBody) {
        return this.restAPI.lookupRegistration(serverName, userId, requestBody);
    }

    @GetMapping(path={"/report"})
    public InformationViewOMASAPIResponse retrieveReport(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @NotBlank(message="report id should not be blank") @RequestParam @NotBlank(message="report id should not be blank") String reportId) {
        return this.restAPI.retrieveReport(serverName, userId, reportId);
    }

    @GetMapping(path={"/dataview"})
    public InformationViewOMASAPIResponse retrieveDataView(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @NotBlank(message="data view id should not be blank") @RequestParam @NotBlank(message="data view id should not be blank") String dataViewId) {
        return this.restAPI.retrieveDataView(serverName, userId, dataViewId);
    }
}

