/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.infrastructure.connector;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ITInfrastructureEventListener;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.CapabilityManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectorTypeManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.DataAssetManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.EndpointManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.HostManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureEventClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITProfileManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.PlatformManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ProcessManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ServerManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.DeploymentElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.HostElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ITProfileElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.RelatedAssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ServerAssetUseElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.SoftwareServerElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.SoftwareServerPlatformElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.CapabilityDeploymentProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ControlFlowProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.DataFlowProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.DeploymentProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.HostProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ITProfileProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.LineageMappingProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessCallProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ProfileIdentityProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ServerAssetUseProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ServerAssetUseType;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareCapabilityProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareServerPlatformProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareServerProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;

public class InfrastructureIntegratorContext
extends IntegrationContext {
    private final CapabilityManagerClient capabilityManagerClient;
    private final ConnectionManagerClient connectionManagerClient;
    private final ConnectorTypeManagerClient connectorTypeManagerClient;
    private final DataAssetManagerClient dataAssetManagerClient;
    private final EndpointManagerClient endpointManagerClient;
    private final HostManagerClient hostManagerClient;
    private final ITProfileManagerClient itProfileManagerClient;
    private final PlatformManagerClient platformManagerClient;
    private final ProcessManagerClient processManagerClient;
    private final ServerManagerClient serverManagerClient;
    private final ITInfrastructureEventClient eventClient;
    private boolean infrastructureManagerIsHome = true;
    static final String assetTypeName = "Asset";

    public InfrastructureIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, CapabilityManagerClient capabilityManagerClient, ConnectionManagerClient connectionManagerClient, ConnectorTypeManagerClient connectorTypeManagerClient, DataAssetManagerClient dataAssetManagerClient, EndpointManagerClient endpointManagerClient, HostManagerClient hostManagerClient, ITProfileManagerClient itProfileManagerClient, PlatformManagerClient platformManagerClient, ProcessManagerClient processManagerClient, ServerManagerClient serverManagerClient, ITInfrastructureEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID);
        this.capabilityManagerClient = capabilityManagerClient;
        this.connectionManagerClient = connectionManagerClient;
        this.connectorTypeManagerClient = connectorTypeManagerClient;
        this.dataAssetManagerClient = dataAssetManagerClient;
        this.endpointManagerClient = endpointManagerClient;
        this.hostManagerClient = hostManagerClient;
        this.itProfileManagerClient = itProfileManagerClient;
        this.platformManagerClient = platformManagerClient;
        this.processManagerClient = processManagerClient;
        this.serverManagerClient = serverManagerClient;
        this.eventClient = eventClient;
    }

    public void setInfrastructureManagerIsHome(boolean infrastructureManagerIsHome) {
        this.infrastructureManagerIsHome = infrastructureManagerIsHome;
    }

    public void registerListener(ITInfrastructureEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createHost(HostProperties hostProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.createHost(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, hostProperties);
    }

    public String createHostFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.createHostFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateHost(String hostGUID, boolean isMergeUpdate, HostProperties hostProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.updateHost(this.userId, this.externalSourceGUID, this.externalSourceName, hostGUID, isMergeUpdate, hostProperties);
    }

    public void setupClusterMember(String hostGUID, String clusterMemberGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.setupClusterMember(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, hostGUID, clusterMemberGUID, effectiveFrom, effectiveTo);
    }

    public void clearClusterMember(String hostGUID, String clusterMemberGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.clearClusterMember(this.userId, this.externalSourceGUID, this.externalSourceName, hostGUID, clusterMemberGUID, effectiveTime);
    }

    public void publishHost(String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.publishHost(this.userId, hostGUID);
    }

    public void withdrawHost(String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.withdrawHost(this.userId, hostGUID);
    }

    public void removeHost(String hostGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.hostManagerClient.removeHost(this.userId, this.externalSourceGUID, this.externalSourceName, hostGUID);
    }

    public List<HostElement> findHosts(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.findHosts(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<HostElement> getHostsByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.getHostsByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<HostElement> getHostsForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.getHostsForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public List<HostElement> getClusterMembersForHost(String hostGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.getClusterMembersForHost(this.userId, hostGUID, effectiveTime, startFrom, pageSize);
    }

    public HostElement getHostByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.hostManagerClient.getHostByGUID(this.userId, guid);
    }

    public String createSoftwareServerPlatform(SoftwareServerPlatformProperties platformProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.createSoftwareServerPlatform(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, platformProperties);
    }

    public String createSoftwareServerPlatformFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.createSoftwareServerPlatformFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateSoftwareServerPlatform(String platformGUID, boolean isMergeUpdate, SoftwareServerPlatformProperties platformProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.platformManagerClient.updateSoftwareServerPlatform(this.userId, this.externalSourceGUID, this.externalSourceName, platformGUID, isMergeUpdate, platformProperties);
    }

    public void publishSoftwareServerPlatform(String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.platformManagerClient.publishSoftwareServerPlatform(this.userId, platformGUID);
    }

    public void withdrawSoftwareServerPlatform(String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.platformManagerClient.withdrawSoftwareServerPlatform(this.userId, platformGUID);
    }

    public void removeSoftwareServerPlatform(String platformGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.platformManagerClient.removeSoftwareServerPlatform(this.userId, this.externalSourceGUID, this.externalSourceName, platformGUID);
    }

    public List<SoftwareServerPlatformElement> findSoftwareServerPlatforms(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.findSoftwareServerPlatforms(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareServerPlatformElement> getSoftwareServerPlatformsByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.getSoftwareServerPlatformsByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareServerPlatformElement> getSoftwareServerPlatformsForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.getSoftwareServerPlatformsForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public SoftwareServerPlatformElement getSoftwareServerPlatformByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformManagerClient.getSoftwareServerPlatformByGUID(this.userId, guid);
    }

    public String createSoftwareServer(SoftwareServerProperties softwareServerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.createSoftwareServer(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, softwareServerProperties);
    }

    public String createSoftwareServerFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.createSoftwareServerFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateSoftwareServer(String softwareServerGUID, boolean isMergeUpdate, SoftwareServerProperties softwareServerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.updateSoftwareServer(this.userId, this.externalSourceGUID, this.externalSourceName, softwareServerGUID, isMergeUpdate, softwareServerProperties);
    }

    public void publishSoftwareServer(String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.publishSoftwareServer(this.userId, softwareServerGUID);
    }

    public void withdrawSoftwareServer(String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.withdrawSoftwareServer(this.userId, softwareServerGUID);
    }

    public void removeSoftwareServer(String softwareServerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.removeSoftwareServer(this.userId, this.externalSourceGUID, this.externalSourceName, softwareServerGUID);
    }

    public List<SoftwareServerElement> findSoftwareServers(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.findSoftwareServers(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareServerElement> getSoftwareServersByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.getSoftwareServersByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareServerElement> getSoftwareServersForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.getSoftwareServersForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public SoftwareServerElement getSoftwareServerByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.getSoftwareServerByGUID(this.userId, guid);
    }

    public void addServerPurpose(String itAssetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, Map<String, Object> classificationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.addServerPurpose(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, itAssetGUID, classificationName, effectiveFrom, effectiveTo, classificationProperties);
    }

    public void updateServerPurpose(String assetGUID, String classificationName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, Map<String, Object> classificationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.updateServerPurpose(this.userId, this.externalSourceGUID, this.externalSourceName, assetTypeName, assetGUID, classificationName, effectiveFrom, effectiveTo, isMergeUpdate, classificationProperties);
    }

    public void clearServerPurpose(String assetGUID, String classificationName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.clearServerPurpose(this.userId, this.externalSourceGUID, this.externalSourceName, assetTypeName, assetGUID, classificationName, effectiveTime);
    }

    public void deployITAsset(String itAssetGUID, String destinationGUID, DeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.deployITAsset(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, itAssetGUID, destinationGUID, deploymentProperties);
    }

    public void updateITAssetDeployment(String deploymentGUID, boolean isMergeUpdate, DeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.updateITAssetDeployment(this.userId, this.externalSourceGUID, this.externalSourceName, deploymentGUID, isMergeUpdate, deploymentProperties);
    }

    public void clearDeployment(String itAssetGUID, String destinationGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.serverManagerClient.clearDeployment(this.userId, this.externalSourceGUID, this.externalSourceName, itAssetGUID, destinationGUID, effectiveTime);
    }

    public List<DeploymentElement> getDeployedITAssets(String destinationGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.getDeployedITAssets(this.userId, destinationGUID, effectiveTime, startFrom, pageSize);
    }

    public List<DeploymentElement> getDeploymentDestinations(String itAssetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.serverManagerClient.getDeploymentDestinations(this.userId, itAssetGUID, effectiveTime, startFrom, pageSize);
    }

    public String createSoftwareCapability(String classificationName, SoftwareCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.createSoftwareCapability(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, classificationName, capabilityProperties);
    }

    public String createSoftwareCapabilityFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.createSoftwareCapabilityFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateSoftwareCapability(String capabilityGUID, boolean isMergeUpdate, SoftwareCapabilityProperties capabilityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.updateSoftwareCapability(this.userId, this.externalSourceGUID, this.externalSourceName, capabilityGUID, isMergeUpdate, capabilityProperties);
    }

    public void deployCapability(String capabilityGUID, String infrastructureAssetGUID, CapabilityDeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.deployCapability(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, capabilityGUID, infrastructureAssetGUID, deploymentProperties);
    }

    public void updateCapabilityDeployment(String deploymentGUID, boolean isMergeUpdate, CapabilityDeploymentProperties deploymentProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.updateCapabilityDeployment(this.userId, this.externalSourceGUID, this.externalSourceName, deploymentGUID, isMergeUpdate, deploymentProperties);
    }

    public void removeCapabilityDeployment(String itAssetGUID, String capabilityGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.removeCapabilityDeployment(this.userId, this.externalSourceGUID, this.externalSourceName, itAssetGUID, capabilityGUID, effectiveTime);
    }

    public void removeSoftwareCapability(String capabilityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.removeSoftwareCapability(this.userId, this.externalSourceGUID, this.externalSourceName, capabilityGUID);
    }

    public List<SoftwareCapabilityElement> findSoftwareCapabilities(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.findSoftwareCapabilities(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareCapabilityElement> getSoftwareCapabilitiesByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getSoftwareCapabilitiesByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedAssetElement> getSoftwareCapabilityDeployments(String guid, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getSoftwareCapabilityDeployments(this.userId, guid, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareCapabilityElement> getDeployedSoftwareCapabilities(String itAssetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getDeployedSoftwareCapabilities(this.userId, itAssetGUID, effectiveTime, startFrom, pageSize);
    }

    public List<SoftwareCapabilityElement> getSoftwareCapabilitiesForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getSoftwareCapabilitiesForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public SoftwareCapabilityElement getSoftwareCapabilityByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getSoftwareCapabilityByGUID(this.userId, guid);
    }

    public String createServerAssetUse(String capabilityGUID, String assetGUID, ServerAssetUseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.createServerAssetUse(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, capabilityGUID, assetGUID, properties);
    }

    public void updateServerAssetUse(String serverAssetUseGUID, boolean isMergeUpdate, ServerAssetUseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.updateServerAssetUse(this.userId, this.externalSourceGUID, this.externalSourceName, serverAssetUseGUID, isMergeUpdate, properties);
    }

    public void removeServerAssetUse(String serverAssetUseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.capabilityManagerClient.removeServerAssetUse(this.userId, this.externalSourceGUID, this.externalSourceName, serverAssetUseGUID);
    }

    public List<ServerAssetUseElement> getServerAssetUsesForCapability(String capabilityGUID, ServerAssetUseType useType, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getServerAssetUsesForCapability(this.userId, capabilityGUID, useType, effectiveTime, startFrom, pageSize);
    }

    public List<ServerAssetUseElement> getCapabilityUsesForAsset(String assetGUID, ServerAssetUseType useType, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getCapabilityUsesForAsset(this.userId, assetGUID, useType, effectiveTime, startFrom, pageSize);
    }

    public List<ServerAssetUseElement> getServerAssetUsesForElements(String capabilityGUID, String assetGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getServerAssetUsesForElements(this.userId, capabilityGUID, assetGUID, effectiveTime, startFrom, pageSize);
    }

    public ServerAssetUseElement getServerAssetUseByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.capabilityManagerClient.getServerAssetUseByGUID(this.userId, guid);
    }

    public String createDataAsset(DataAssetProperties dataAssetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.createDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, dataAssetProperties);
    }

    public String createDataAssetFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.createDataAssetFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateDataAsset(String assetGUID, boolean isMergeUpdate, DataAssetProperties dataAssetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.updateDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, isMergeUpdate, dataAssetProperties);
    }

    public void setDataAssetAsReferenceData(String assetGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.setDataAssetAsReferenceData(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, effectiveFrom, effectiveTo);
    }

    public void clearDataAssetAsReferenceData(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.clearDataAssetAsReferenceData(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, effectiveTime);
    }

    public void publishDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.publishDataAsset(this.userId, assetGUID);
    }

    public void withdrawDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.withdrawDataAsset(this.userId, assetGUID);
    }

    public void removeDataAsset(String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataAssetManagerClient.removeDataAsset(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID);
    }

    public List<DataAssetElement> findDataAssets(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.findDataAssets(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.getDataAssetsByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.getDataAssetsForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public DataAssetElement getDataAssetByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetManagerClient.getDataAssetByGUID(this.userId, guid);
    }

    public String createProcess(ProcessStatus processStatus, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.createProcess(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, processStatus, processProperties);
    }

    public String createProcessFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.createProcessFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, templateGUID, templateProperties);
    }

    public void updateProcess(String processGUID, boolean isMergeUpdate, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, isMergeUpdate, processProperties);
    }

    public void updateProcessStatus(String processGUID, ProcessStatus processStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateProcessStatus(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID, processStatus);
    }

    public void setupProcessParent(String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.setupProcessParent(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, parentProcessGUID, childProcessGUID, containmentType, effectiveFrom, effectiveTo);
    }

    public void clearProcessParent(String parentProcessGUID, String childProcessGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearProcessParent(this.userId, this.externalSourceGUID, this.externalSourceName, parentProcessGUID, childProcessGUID, effectiveTime);
    }

    public void publishProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.publishProcess(this.userId, processGUID);
    }

    public void withdrawProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.withdrawProcess(this.userId, processGUID);
    }

    public void removeProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.removeProcess(this.userId, this.externalSourceGUID, this.externalSourceName, processGUID);
    }

    public List<ProcessElement> findProcesses(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.findProcesses(this.userId, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessesByName(this.userId, name, effectiveTime, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesForInfrastructureManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessesForInfrastructureManager(this.userId, this.externalSourceGUID, this.externalSourceName, effectiveTime, startFrom, pageSize);
    }

    public ProcessElement getProcessByGUID(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessByGUID(this.userId, processGUID);
    }

    public ProcessElement getProcessParent(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessParent(this.userId, processGUID, effectiveTime);
    }

    public List<ProcessElement> getSubProcesses(String processGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getSubProcesses(this.userId, processGUID, effectiveTime, startFrom, pageSize);
    }

    public void setBusinessSignificant(String elementGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.setBusinessSignificant(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, effectiveFrom, effectiveTo);
    }

    public void clearBusinessSignificant(String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearBusinessSignificant(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, effectiveTime);
    }

    public String setupDataFlow(String dataSupplierGUID, String dataConsumerGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.setupDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, dataSupplierGUID, dataConsumerGUID, properties, effectiveTime);
    }

    public DataFlowElement getDataFlow(String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getDataFlow(this.userId, dataSupplierGUID, dataConsumerGUID, qualifiedName, effectiveTime);
    }

    public void updateDataFlow(String dataFlowGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, dataFlowGUID, properties, effectiveTime);
    }

    public void clearDataFlow(String dataFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearDataFlow(this.userId, this.externalSourceGUID, this.externalSourceName, dataFlowGUID, effectiveTime);
    }

    public List<DataFlowElement> getDataFlowConsumers(String dataSupplierGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getDataFlowConsumers(this.userId, dataSupplierGUID, startFrom, pageSize, effectiveTime);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String dataConsumerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getDataFlowSuppliers(this.userId, dataConsumerGUID, startFrom, pageSize, effectiveTime);
    }

    public String setupControlFlow(String currentStepGUID, String nextStepGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.setupControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, currentStepGUID, nextStepGUID, properties, effectiveTime);
    }

    public ControlFlowElement getControlFlow(String currentStepGUID, String nextStepGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getControlFlow(this.userId, currentStepGUID, nextStepGUID, qualifiedName, effectiveTime);
    }

    public void updateControlFlow(String controlFlowGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, controlFlowGUID, properties, effectiveTime);
    }

    public void clearControlFlow(String controlFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearControlFlow(this.userId, this.externalSourceGUID, this.externalSourceName, controlFlowGUID, effectiveTime);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getControlFlowNextSteps(this.userId, currentStepGUID, startFrom, pageSize, effectiveTime);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getControlFlowPreviousSteps(this.userId, currentStepGUID, startFrom, pageSize, effectiveTime);
    }

    public String setupProcessCall(String callerGUID, String calledGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.setupProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, this.infrastructureManagerIsHome, callerGUID, calledGUID, properties, effectiveTime);
    }

    public ProcessCallElement getProcessCall(String callerGUID, String calledGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessCall(this.userId, callerGUID, calledGUID, qualifiedName, effectiveTime);
    }

    public void updateProcessCall(String processCallGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, processCallGUID, properties, effectiveTime);
    }

    public void clearProcessCall(String processCallGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearProcessCall(this.userId, this.externalSourceGUID, this.externalSourceName, processCallGUID, effectiveTime);
    }

    public List<ProcessCallElement> getProcessCalled(String callerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessCalled(this.userId, callerGUID, startFrom, pageSize, effectiveTime);
    }

    public List<ProcessCallElement> getProcessCallers(String calledGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getProcessCallers(this.userId, calledGUID, startFrom, pageSize, effectiveTime);
    }

    public void setupLineageMapping(String sourceElementGUID, String destinationElementGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.setupLineageMapping(this.userId, sourceElementGUID, destinationElementGUID, properties, effectiveTime);
    }

    public LineageMappingElement getLineageMapping(String sourceElementGUID, String destinationElementGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getLineageMapping(this.userId, sourceElementGUID, destinationElementGUID, qualifiedName, effectiveTime);
    }

    public void updateLineageMapping(String lineageMappingGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.updateLineageMapping(this.userId, this.externalSourceGUID, this.externalSourceName, lineageMappingGUID, properties, effectiveTime);
    }

    public void clearLineageMapping(String lineageMappingGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.processManagerClient.clearLineageMapping(this.userId, lineageMappingGUID, effectiveTime);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String sourceElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getDestinationLineageMappings(this.userId, sourceElementGUID, startFrom, pageSize, effectiveTime);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String destinationElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.processManagerClient.getSourceLineageMappings(this.userId, destinationElementGUID, startFrom, pageSize, effectiveTime);
    }

    public String createConnection(ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionProperties);
    }

    public String createConnectionFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnectionFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties);
    }

    public void updateConnection(String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, isMergeUpdate, connectionProperties);
    }

    public void setupConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectorTypeGUID);
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectorTypeGUID);
    }

    public void setupEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, endpointGUID);
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, endpointGUID);
    }

    public void setupEmbeddedConnection(String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEmbeddedConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, position, displayName, arguments, embeddedConnectionGUID);
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEmbeddedConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, embeddedConnectionGUID);
    }

    public void setupAssetConnection(String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupAssetConnection(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, assetSummary, connectionGUID);
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearAssetConnection(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, connectionGUID);
    }

    public void removeConnection(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnections(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionsByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionByGUID(this.userId, connectionGUID);
    }

    public String createEndpoint(String infrastructureGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.createEndpoint(this.userId, null, null, infrastructureGUID, endpointProperties);
    }

    public String createEndpointFromTemplate(String infrastructureGUID, String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.createEndpointFromTemplate(this.userId, null, null, infrastructureGUID, networkAddress, templateGUID, templateProperties);
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.endpointManagerClient.updateEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, isMergeUpdate, endpointGUID, endpointProperties);
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.endpointManagerClient.removeEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, endpointGUID);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByNetworkAddress(String networkAddress, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.getEndpointsByNetworkAddress(this.userId, networkAddress, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsForInfrastructure(String infrastructureGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.getEndpointsForInfrastructure(this.userId, infrastructureGUID, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.endpointManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public String createConnectorType(ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectorTypeManagerClient.createConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeProperties);
    }

    public String createConnectorTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectorTypeManagerClient.createConnectorTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties);
    }

    public void updateConnectorType(boolean isMergeUpdate, String connectorTypeGUID, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectorTypeManagerClient.updateConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, isMergeUpdate, connectorTypeGUID, connectorTypeProperties);
    }

    public void removeConnectorType(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectorTypeManagerClient.removeConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeGUID);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectorTypeManagerClient.findConnectorTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectorTypeManagerClient.getConnectorTypesByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectorTypeManagerClient.getConnectorTypeByGUID(this.userId, connectorTypeGUID);
    }

    public String createITProfile(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itInfrastructureGUID, String itUserId, ITProfileProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.createITProfile(userId, infrastructureManagerGUID, infrastructureManagerName, itInfrastructureGUID, itUserId, properties);
    }

    public void updateITProfile(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itProfileGUID, boolean isMergeUpdate, ITProfileProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.itProfileManagerClient.updateITProfile(userId, infrastructureManagerGUID, infrastructureManagerName, itProfileGUID, isMergeUpdate, properties);
    }

    public void deleteITProfile(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.itProfileManagerClient.deleteITProfile(userId, infrastructureManagerGUID, infrastructureManagerName, itProfileGUID);
    }

    public String addContactMethod(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String itProfileGUID, ContactMethodProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.itProfileManagerClient.addContactMethod(userId, infrastructureManagerGUID, infrastructureManagerName, itProfileGUID, properties);
    }

    public void deleteContactMethod(String userId, String infrastructureManagerGUID, String infrastructureManagerName, String contactMethodGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.deleteContactMethod(userId, infrastructureManagerGUID, infrastructureManagerName, contactMethodGUID);
    }

    public void linkITInfrastructureToProfile(String itInfrastructureGUID, String itProfileGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.itProfileManagerClient.linkITInfrastructureToProfile(this.userId, this.externalSourceGUID, this.externalSourceName, itInfrastructureGUID, itProfileGUID, effectiveFrom, effectiveTo);
    }

    public void updateITInfrastructureToProfile(String itInfrastructureGUID, String itProfileGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.itProfileManagerClient.updateITInfrastructureToProfile(this.userId, this.externalSourceGUID, this.externalSourceName, itInfrastructureGUID, itProfileGUID, effectiveFrom, effectiveTo);
    }

    public void unlinkITInfrastructureFromProfile(String itInfrastructureGUID, String itProfileGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.itProfileManagerClient.unlinkITInfrastructureFromProfile(this.userId, this.externalSourceGUID, this.externalSourceName, itInfrastructureGUID, itProfileGUID, effectiveTime);
    }

    public ITProfileElement getITProfileByGUID(String itProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.getITProfileByGUID(this.userId, itProfileGUID);
    }

    public ITProfileElement getITProfileByUserId(String itProfileUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.getITProfileByUserId(this.userId, itProfileUserId);
    }

    public List<ITProfileElement> getITProfileByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.getITProfileByName(this.userId, name, startFrom, pageSize);
    }

    public List<ITProfileElement> findITProfile(String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.itProfileManagerClient.findITProfile(this.userId, searchString, startFrom, pageSize);
    }

    public String createUserIdentity(UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.itProfileManagerClient.createUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, newIdentity);
    }

    public void updateUserIdentity(String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.updateUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, isMergeUpdate, properties);
    }

    public void deleteUserIdentity(String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.deleteUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID);
    }

    public void addIdentityToProfile(String userIdentityGUID, String profileGUID, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.addIdentityToProfile(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID, properties);
    }

    public void updateProfileIdentity(String userIdentityGUID, String profileGUID, boolean isMergeUpdate, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.updateProfileIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID, isMergeUpdate, properties);
    }

    public void removeIdentityFromProfile(String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.itProfileManagerClient.removeIdentityFromProfile(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID);
    }

    public List<UserIdentityElement> findUserIdentities(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.findUserIdentities(this.userId, searchString, startFrom, pageSize);
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.getUserIdentitiesByName(this.userId, name, startFrom, pageSize);
    }

    public UserIdentityElement getUserIdentityByGUID(String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.itProfileManagerClient.getUserIdentityByGUID(this.userId, userIdentityGUID);
    }
}

