/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.infrastructure.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum InfrastructureIntegratorAuditCode implements AuditLogMessageSet
{
    CONTEXT_INITIALIZING("OMIS-INFRASTRUCTURE-INTEGRATOR-0001", AuditLogRecordSeverityLevel.STARTUP, "The infrastructure integrator context manager is being initialized for calls to server {0} on platform {1}", "The Infrastructure Integrator OMIS is initializing its context manager.", "Verify that the start up sequence goes on to initialize the context for each connector configured for this service."),
    CONNECTOR_CONTEXT_INITIALIZING("OMIS-INFRASTRUCTURE-INTEGRATOR-0002", AuditLogRecordSeverityLevel.STARTUP, "Creating context for integration connector {0} ({1}) connecting to third party technology {2} with permitted synchronization of {3} and service options of {4}", "A new context is created for an integration connector.  This acts as a client to the open metadata repositories enabling the integration connector to synchronize open metadata with the third party technology's metadata", "Verify that this connector is being started with the correct configuration."),
    PERMITTED_SYNCHRONIZATION("OMIS-INFRASTRUCTURE-INTEGRATOR-0003", AuditLogRecordSeverityLevel.STARTUP, "The context for connector {0} has its permitted synchronization set to {1}", "The context is set up to ensure that the connector can only issue requests that support the permitted synchronization.  If the connector issues requests that are not permitted it is returned UserNotAuthorizedExceptions.", "Check that this permitted synchronized value is as expected.  If it is not, change the configuration for this connector and restart the integration daemon."),
    DISABLED_EXCHANGE_SERVICES("OMIS-INFRASTRUCTURE-INTEGRATOR-0004", AuditLogRecordSeverityLevel.STARTUP, "The following exchange services are disabled in the context for connector {1}: {2}", "The context is set up to ensure that the connector can only issue requests to supported services.  If the connector issues requests that are not permitted it is returned UserNotAuthorizedExceptions.", "Check that this value is as expected.  If it is not, change the configuration for this connector and restart the integration daemon."),
    NULL_CONTEXT("OMIS-INFRASTRUCTURE-INTEGRATOR-0005", AuditLogRecordSeverityLevel.ERROR, "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private InfrastructureIntegratorAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

