/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.infrastructure.contextmanager;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.CapabilityManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectorTypeManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.DataAssetManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.EndpointManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.HostManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureEventClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITProfileManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.PlatformManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ProcessManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ServerManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.SoftwareCapabilityElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareCapabilityProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorConnector;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorContext;
import org.odpi.openmetadata.integrationservices.infrastructure.ffdc.InfrastructureIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.infrastructure.ffdc.InfrastructureIntegratorErrorCode;

public class InfrastructureIntegratorContextManager
extends IntegrationContextManager {
    private CapabilityManagerClient capabilityManagerClient = null;
    private ConnectionManagerClient connectionManagerClient = null;
    private ConnectorTypeManagerClient connectorTypeManagerClient = null;
    private DataAssetManagerClient dataAssetManagerClient = null;
    private EndpointManagerClient endpointManagerClient = null;
    private HostManagerClient hostManagerClient = null;
    private ITProfileManagerClient itProfileManagerClient = null;
    private PlatformManagerClient platformManagerClient = null;
    private ProcessManagerClient processManagerClient = null;
    private ServerManagerClient serverManagerClient = null;
    private ITInfrastructureRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", InfrastructureIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        this.restClient = this.localServerPassword == null ? new ITInfrastructureRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new ITInfrastructureRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.connectionManagerClient = new ConnectionManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.capabilityManagerClient = new CapabilityManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.connectorTypeManagerClient = new ConnectorTypeManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.dataAssetManagerClient = new DataAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.endpointManagerClient = new EndpointManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.hostManagerClient = new HostManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.itProfileManagerClient = new ITProfileManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.platformManagerClient = new PlatformManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.processManagerClient = new ProcessManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.serverManagerClient = new ServerManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = null;
        List softwareCapabilityElements = this.capabilityManagerClient.getSoftwareCapabilitiesByName(this.localServerUserId, metadataSourceQualifiedName, null, 0, 0);
        if (softwareCapabilityElements != null && !softwareCapabilityElements.isEmpty()) {
            metadataSourceGUID = ((SoftwareCapabilityElement)softwareCapabilityElements.get(0)).getElementHeader().getGUID();
        }
        if (metadataSourceGUID == null) {
            SoftwareCapabilityProperties properties = new SoftwareCapabilityProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.capabilityManagerClient.createSoftwareCapability(this.localServerUserId, null, null, false, null, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof InfrastructureIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(InfrastructureIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.INFRASTRUCTURE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), InfrastructureIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", InfrastructureIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        InfrastructureIntegratorConnector serviceSpecificConnector = (InfrastructureIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        ITInfrastructureEventClient eventClient = new ITInfrastructureEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
        serviceSpecificConnector.setContext(new InfrastructureIntegratorContext(this.capabilityManagerClient, this.connectionManagerClient, this.connectorTypeManagerClient, this.dataAssetManagerClient, this.endpointManagerClient, this.hostManagerClient, this.itProfileManagerClient, this.platformManagerClient, this.processManagerClient, this.serverManagerClient, eventClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName));
    }
}

