/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.infrastructure.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.CapabilityManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectorTypeManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.DataAssetManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.EndpointManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.HostManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITInfrastructureEventClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ITProfileManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.PlatformManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ProcessManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ServerManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.rest.ITInfrastructureRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorConnector;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorContext;
import org.odpi.openmetadata.integrationservices.infrastructure.ffdc.InfrastructureIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.infrastructure.ffdc.InfrastructureIntegratorErrorCode;

public class InfrastructureIntegratorContextManager
extends IntegrationContextManager {
    private CapabilityManagerClient capabilityManagerClient = null;
    private ConnectionManagerClient connectionManagerClient = null;
    private ConnectorTypeManagerClient connectorTypeManagerClient = null;
    private DataAssetManagerClient dataAssetManagerClient = null;
    private EndpointManagerClient endpointManagerClient = null;
    private HostManagerClient hostManagerClient = null;
    private ITProfileManagerClient itProfileManagerClient = null;
    private PlatformManagerClient platformManagerClient = null;
    private ProcessManagerClient processManagerClient = null;
    private ServerManagerClient serverManagerClient = null;
    private ITInfrastructureRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", InfrastructureIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients(int maxPageSize) throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.actionControlInterface = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.governanceConfiguration = new GovernanceConfigurationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.restClient = this.localServerPassword == null ? new ITInfrastructureRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new ITInfrastructureRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.connectionManagerClient = new ConnectionManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.capabilityManagerClient = new CapabilityManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.connectorTypeManagerClient = new ConnectorTypeManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.dataAssetManagerClient = new DataAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.endpointManagerClient = new EndpointManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.hostManagerClient = new HostManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.itProfileManagerClient = new ITProfileManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.platformManagerClient = new PlatformManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.processManagerClient = new ProcessManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
        this.serverManagerClient = new ServerManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, maxPageSize);
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof InfrastructureIntegratorConnector) {
            InfrastructureIntegratorConnector serviceSpecificConnector = (InfrastructureIntegratorConnector)integrationConnector;
            this.auditLog.logMessage("setContext", InfrastructureIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, DeployedImplementationType.ASSET_CATALOG.getAssociatedTypeName(), DeployedImplementationType.ASSET_CATALOG.getAssociatedClassification(), DeployedImplementationType.ASSET_CATALOG.getDeployedImplementationType());
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            ITInfrastructureEventClient eventClient = new ITInfrastructureEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
            InfrastructureIntegratorContext integratorContext = new InfrastructureIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.governanceConfiguration, this.openMetadataStoreClient, this.actionControlInterface, this.capabilityManagerClient, this.connectionManagerClient, this.connectorTypeManagerClient, this.dataAssetManagerClient, this.endpointManagerClient, this.hostManagerClient, this.itProfileManagerClient, this.platformManagerClient, this.processManagerClient, this.serverManagerClient, eventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, this.auditLog, this.maxPageSize);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(InfrastructureIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.INFRASTRUCTURE_INTEGRATOR_OMIS.getIntegrationServiceFullName(), InfrastructureIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

