/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.context;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;

public abstract class IntegrationContext {
    private Map<String, Integer> counterMap = new HashMap<String, Integer>();
    private Map<String, String> propertyMap = new HashMap<String, String>();
    private Map<String, Date> timestampMap = new HashMap<String, Date>();

    protected IntegrationContext() {
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        if (!this.counterMap.isEmpty()) {
            statistics.putAll(this.counterMap);
        }
        if (!this.propertyMap.isEmpty()) {
            statistics.putAll(this.propertyMap);
        }
        if (!this.timestampMap.isEmpty()) {
            statistics.putAll(this.timestampMap);
        }
        if (statistics.isEmpty()) {
            return null;
        }
        return statistics;
    }

    public void initializeCounter(String counterName, int counterValue, String methodName) throws InvalidParameterException {
        String actionDescription = "initialize a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "initialize a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "initialize a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        this.counterMap.put(counterName, counterValue);
    }

    public void incrementCounter(String counterName, String methodName) throws InvalidParameterException {
        String actionDescription = "increment a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        int counterValue = 1;
        if (this.counterMap.get(counterName) != null) {
            counterValue = this.counterMap.get(counterName);
        }
        this.counterMap.put(counterName, counterValue);
    }

    public int getCounter(String counterName, String methodName) throws InvalidParameterException {
        String actionDescription = "increment a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        this.counterMap.putIfAbsent(counterName, 0);
        return this.counterMap.get(counterName);
    }

    public void setProperty(String propertyName, String propertyValue, String methodName) throws InvalidParameterException {
        String actionDescription = "set a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "set a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "set a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        this.propertyMap.put(propertyName, propertyValue);
    }

    public void clearProperty(String propertyName, String methodName) throws InvalidParameterException {
        String actionDescription = "remove a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "remove a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "remove a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        this.propertyMap.remove(propertyName);
    }

    public String getProperty(String propertyName, String methodName) throws InvalidParameterException {
        String actionDescription = "retrieve a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "retrieve a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "retrieve a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        return this.propertyMap.get(propertyName);
    }

    public void setTimestamp(String timestampName, Date timestampValue, String methodName) throws InvalidParameterException {
        String actionDescription = "set a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "set a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "set a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        this.timestampMap.put(timestampName, timestampValue);
    }

    public void clearTimestamp(String timestampName, String methodName) throws InvalidParameterException {
        String actionDescription = "remove a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "remove a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "remove a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        this.timestampMap.remove(timestampName);
    }

    public Date getTimestamp(String timestampName, String methodName) throws InvalidParameterException {
        String actionDescription = "retrieve a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "retrieve a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "retrieve a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        return this.timestampMap.get(timestampName);
    }
}

