/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum IntegrationGroupStatus {
    ASSIGNED(0, "Assigned", "The integration group is assigned to the integration daemon server but has not yet been configured."),
    CONFIGURING(1, "Configuring", "The integration group is retrieving its configuration from the metadata server."),
    RUNNING(2, "Running", "The integration group is operational and able to service all defined governance requests on demand."),
    FAILED(3, "Failed", "The integration group is unable to run successfully due to an error in its configuration."),
    DISABLED(4, "Disabled", "The integration group has been disabled. It is waiting to be enabled before it can service any more governance requests.");

    private static final long serialVersionUID = 1L;
    private final int ordinal;
    private final String statusName;
    private final String statusDescription;

    private IntegrationGroupStatus(int ordinal, String statusName, String statusDescription) {
        this.ordinal = ordinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }
}

