/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.api.IntegrationDaemonAPI;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.client.IntegrationDaemonServicesRESTClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;

public class IntegrationDaemon
implements IntegrationDaemonAPI {
    private IntegrationDaemonServicesRESTClient restClient;
    private String serverName;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static NullRequestBody nullRequestBody = new NullRequestBody();

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, auditLog);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public void refreshAllServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAllServices";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/refresh";
        this.invalidParameterHandler.validateUserId(userId, "refreshAllServices");
        this.restClient.callVoidPostRESTCall("refreshAllServices", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/refresh", nullRequestBody, new Object[]{this.serverName, userId});
    }

    public void refreshService(String userId, String serviceURLMarker, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshService";
        String nameParameter = "serviceURLMarker";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/refresh";
        this.invalidParameterHandler.validateUserId(userId, "refreshService");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "refreshService");
        this.restClient.callVoidPostRESTCall("refreshService", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/refresh", connectorName, new Object[]{this.serverName, userId, serviceURLMarker});
    }

    public void restartService(String userId, String serviceURLMarker, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshService";
        String nameParameter = "serviceURLMarker";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/restart";
        this.invalidParameterHandler.validateUserId(userId, "refreshService");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "refreshService");
        this.restClient.callVoidPostRESTCall("refreshService", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/restart", connectorName, new Object[]{this.serverName, userId, serviceURLMarker});
    }

    public List<IntegrationServiceSummary> getIntegrationDaemonStatus(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationDaemonStatus";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/status";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse restResult = this.restClient.callIntegrationDaemonStatusGetRESTCall("getIntegrationDaemonStatus", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/status", this.serverName, userId);
        return restResult.getIntegrationServiceSummaries();
    }
}

