/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.api.IntegrationDaemonAPI;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.client.IntegrationDaemonServicesRESTClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationDaemonStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummariesResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationServiceSummaryResponse;

public class IntegrationDaemon
implements IntegrationDaemonAPI {
    private final IntegrationDaemonServicesRESTClient restClient;
    private final String serverName;
    private final String serverPlatformRootURL;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static final NullRequestBody nullRequestBody = new NullRequestBody();

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, auditLog);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, userId, password, auditLog);
    }

    public IntegrationDaemon(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.restClient = new IntegrationDaemonServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public Map<String, Object> getConfigurationProperties(String userId, String serviceURLMarker, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConfigurationProperties";
        String serviceNameParameterName = "serviceURLMarker";
        String connectorNameParameterName = "connectorName";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/connectors/{3}/configuration-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateConfigurationProperties");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "updateConfigurationProperties");
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "updateConfigurationProperties");
        PropertiesResponse restResult = this.restClient.callPropertiesGetRESTCall("updateConfigurationProperties", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/connectors/{3}/configuration-properties", this.serverName, userId, serviceURLMarker, connectorName);
        return restResult.getProperties();
    }

    public void updateConfigurationProperties(String userId, String serviceURLMarker, String connectorName, boolean isMergeUpdate, Map<String, Object> configurationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConfigurationProperties";
        String serviceNameParameterName = "serviceURLMarker";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/connectors/configuration-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateConfigurationProperties");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "updateConfigurationProperties");
        ConnectorConfigPropertiesRequestBody requestBody = new ConnectorConfigPropertiesRequestBody();
        requestBody.setConnectorName(connectorName);
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setConfigurationProperties(configurationProperties);
        this.restClient.callVoidPostRESTCall("updateConfigurationProperties", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/connectors/configuration-properties", requestBody, new Object[]{this.serverName, userId, serviceURLMarker});
    }

    public void refreshAllServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAllServices";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/refresh";
        this.invalidParameterHandler.validateUserId(userId, "refreshAllServices");
        this.restClient.callVoidPostRESTCall("refreshAllServices", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/refresh", nullRequestBody, new Object[]{this.serverName, userId});
    }

    public void refreshService(String userId, String serviceURLMarker, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshService";
        String nameParameter = "serviceURLMarker";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/refresh";
        this.invalidParameterHandler.validateUserId(userId, "refreshService");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "refreshService");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(connectorName);
        this.restClient.callVoidPostRESTCall("refreshService", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/{2}/refresh", requestBody, new Object[]{this.serverName, userId, serviceURLMarker});
    }

    public void restartService(String userId, String serviceURLMarker, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshService";
        String nameParameter = "serviceURLMarker";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/restart";
        this.invalidParameterHandler.validateUserId(userId, "refreshService");
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "refreshService");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(connectorName);
        this.restClient.callVoidPostRESTCall("refreshService", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-service/{2}/restart", requestBody, new Object[]{this.serverName, userId, serviceURLMarker});
    }

    public IntegrationDaemonStatus getIntegrationDaemonStatus(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationDaemonStatus";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/status";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse restResult = this.restClient.callIntegrationDaemonStatusGetRESTCall("getIntegrationDaemonStatus", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/status", this.serverName, userId);
        return restResult.getIntegrationDaemonStatus();
    }

    public List<IntegrationServiceSummary> getIntegrationServicesSummaries(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationServicesSummaries";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/summary";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationServicesSummaries");
        IntegrationServiceSummaryResponse restResult = this.restClient.callIntegrationServiceStatusGetRESTCall("getIntegrationServicesSummaries", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon/users/{1}/integration-services/summary", this.serverName, userId);
        return restResult.getIntegrationServiceSummaries();
    }

    public IntegrationGroupSummary getIntegrationGroupSummary(String userId, String integrationGroupName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupSummary";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/{2}/summary";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupSummary");
        IntegrationGroupSummaryResponse restResult = this.restClient.callIntegrationGroupSummaryGetRESTCall("getIntegrationGroupSummary", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/{2}/summary", this.serverName, userId, integrationGroupName);
        return restResult.getIntegrationGroupSummary();
    }

    public List<IntegrationGroupSummary> getIntegrationGroupSummaries(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupSummaries";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/summary";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupSummaries");
        IntegrationGroupSummariesResponse restResult = this.restClient.callIntegrationGroupSummariesGetRESTCall("getIntegrationGroupSummaries", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/summary", this.serverName, userId);
        return restResult.getIntegrationGroupSummaries();
    }

    public void refreshConfig(String userId, String integrationGroupName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        String integrationGroupParameterName = "integrationGroupName";
        String urlTemplate = "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/{2}/refresh-config";
        this.invalidParameterHandler.validateUserId(userId, "refreshConfig");
        this.invalidParameterHandler.validateName(integrationGroupName, "integrationGroupName", "refreshConfig");
        this.restClient.callVoidGetRESTCall("refreshConfig", this.serverPlatformRootURL + "/servers/{0}/open-metadata/integration-daemon-services/users/{1}/integration-groups/{2}/refresh-config", new Object[]{this.serverName, userId, integrationGroupName});
    }
}

