/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.slf4j.LoggerFactory;

public class IntegrationDaemonRESTServices {
    private static IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationDaemonRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public PropertiesResponse getConfigurationProperties(String serverName, String userId, String serviceURLMarker, String connectorName) {
        String methodName = "getConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfigurationProperties");
        PropertiesResponse response = new PropertiesResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "getConfigurationProperties");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfigurationProperties");
            response.setProperties(handler.getConfigurationProperties(userId, connectorName));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConfigurationProperties(String serverName, String userId, String serviceURLMarker, ConnectorConfigPropertiesRequestBody requestBody) {
        String methodName = "updateConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConfigurationProperties");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "updateConfigurationProperties");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConfigurationProperties");
            if (requestBody != null) {
                handler.updateConfigurationProperties(userId, requestBody.getConnectorName(), requestBody.getMergeUpdate(), requestBody.getConfigurationProperties());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConfigurationProperties", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshAllServices(String serverName, String userId, NullRequestBody requestBody) {
        String methodName = "refreshAllServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshAllServices");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshAllServices");
            List<IntegrationServiceHandler> handlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "refreshAllServices");
            if (handlers != null) {
                for (IntegrationServiceHandler handler : handlers) {
                    if (handler == null) continue;
                    handler.refreshService(userId);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "refreshAllServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "refreshService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "refreshService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.refreshService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "refreshService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "restartService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restartService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "restartService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.restartService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "restartService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(String serverName, String userId) {
        String methodName = "getIntegrationDaemonStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse response = new IntegrationDaemonStatusResponse();
        AuditLog auditLog = null;
        try {
            List<IntegrationServiceHandler> handlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationDaemonStatus");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationDaemonStatus");
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (handlers != null) {
                for (IntegrationServiceHandler handler : handlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                response.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getIntegrationDaemonStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

