/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;

public class IntegrationServiceHandler {
    private String localServerName;
    private IntegrationServiceConfig serviceConfig;
    private IntegrationContextManager contextManager;
    private AuditLog auditLog;
    private List<IntegrationConnectorHandler> connectorHandlers = new ArrayList<IntegrationConnectorHandler>();

    public IntegrationServiceHandler(String localServerName, IntegrationServiceConfig serviceConfig, IntegrationContextManager contextManager, AuditLog auditLog) {
        this.localServerName = localServerName;
        this.serviceConfig = serviceConfig;
        this.contextManager = contextManager;
        this.auditLog = auditLog;
    }

    public List<IntegrationConnectorHandler> initialize() {
        List connectorConfigurationList = this.serviceConfig.getIntegrationConnectorConfigs();
        if (connectorConfigurationList != null) {
            for (IntegrationConnectorConfig connectorConfig : connectorConfigurationList) {
                IntegrationConnectorHandler connectorHandler;
                if (connectorConfig == null || (connectorHandler = new IntegrationConnectorHandler(connectorConfig, this.serviceConfig.getIntegrationServiceFullName(), this.localServerName, this.contextManager, this.auditLog)).getIntegrationConnectorStatus() == IntegrationConnectorStatus.FAILED) continue;
                this.connectorHandlers.add(connectorHandler);
            }
        }
        if (this.connectorHandlers.isEmpty()) {
            String actionDescription = "Initialize integration service";
            this.connectorHandlers = null;
            this.auditLog.logMessage("Initialize integration service", IntegrationDaemonServicesAuditCode.NO_INTEGRATION_CONNECTORS.getMessageDefinition(new String[]{this.serviceConfig.getIntegrationServiceFullName()}));
        }
        return this.connectorHandlers;
    }

    public IntegrationServiceSummary getSummary() {
        IntegrationServiceSummary summary = new IntegrationServiceSummary();
        summary.setIntegrationServiceId(this.serviceConfig.getIntegrationServiceId());
        summary.setIntegrationServiceFullName(this.serviceConfig.getIntegrationServiceFullName());
        summary.setIntegrationServiceURLMarker(this.serviceConfig.getIntegrationServiceURLMarker());
        summary.setIntegrationServiceDescription(this.serviceConfig.getIntegrationServiceDescription());
        summary.setIntegrationServiceWiki(this.serviceConfig.getIntegrationServiceWiki());
        ArrayList<IntegrationConnectorReport> connectorReports = new ArrayList<IntegrationConnectorReport>();
        if (!this.connectorHandlers.isEmpty()) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                IntegrationConnectorReport connectorReport = new IntegrationConnectorReport();
                connectorReport.setConnectorName(connectorHandler.getIntegrationConnectorName());
                connectorReport.setConnectorStatus(connectorHandler.getIntegrationConnectorStatus());
                connectorReport.setFailingExceptionMessage(connectorHandler.getFailingExceptionMessage());
                connectorReport.setStatistics(connectorHandler.getStatistics());
                connectorReport.setLastStatusChange(connectorHandler.getLastStatusChange());
                connectorReport.setLastRefreshTime(connectorHandler.getLastRefreshTime());
                connectorReport.setMinSecondsBetweenRefresh(connectorHandler.getMinSecondsBetweenRefresh());
                connectorReports.add(connectorReport);
            }
        }
        if (!connectorReports.isEmpty()) {
            summary.setIntegrationConnectorReports(connectorReports);
        }
        return summary;
    }

    public void refreshService(String connectorName) throws InvalidParameterException {
        String actionDescription = "Refresh service REST API call";
        if (connectorName == null) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                connectorHandler.refreshConnector("Refresh service REST API call");
            }
        } else {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null || !connectorName.equals(connectorHandler.getIntegrationConnectorName())) continue;
                connectorHandler.refreshConnector("Refresh service REST API call");
                return;
            }
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serviceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "Refresh service REST API call", "connectorName");
        }
    }

    public void restartService(String connectorName) throws InvalidParameterException {
        String actionDescription = "Restart service REST API call";
        if (connectorName == null) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                connectorHandler.reinitializeConnector("Restart service REST API call");
            }
        } else {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null || !connectorName.equals(connectorHandler.getIntegrationConnectorName())) continue;
                connectorHandler.reinitializeConnector("Restart service REST API call");
                return;
            }
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serviceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "Restart service REST API call", "connectorName");
        }
    }

    public void shutdown() {
        String actionDescription = "Server shutdown";
        for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
            if (connectorHandler == null) continue;
            connectorHandler.shutdown("Server shutdown");
        }
    }
}

