/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationDaemonHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstance;

public class IntegrationDaemonOperationalServices {
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private AuditLog auditLog = null;
    private IntegrationDaemonInstance integrationDaemonInstance = null;

    public IntegrationDaemonOperationalServices(String localServerName, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(List<IntegrationServiceConfig> configuration, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize", IntegrationDaemonServicesAuditCode.SERVER_INITIALIZING.getMessageDefinition(new String[]{this.localServerName}));
        try {
            if (configuration == null) {
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_CONFIG_DOC.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            if (configuration.isEmpty()) {
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_INTEGRATION_SERVICES_CONFIGURED.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            ArrayList<IntegrationConnectorHandler> daemonConnectorHandlers = new ArrayList<IntegrationConnectorHandler>();
            HashMap<String, IntegrationServiceHandler> integrationServiceHandlerMap = new HashMap<String, IntegrationServiceHandler>();
            for (IntegrationServiceConfig integrationServiceConfig : configuration) {
                String partnerOMASRootURL = this.getPartnerOMASRootURL(integrationServiceConfig);
                String partnerOMASServerName = this.getPartnerOMASServerName(integrationServiceConfig);
                String integrationServiceURLMarker = this.getServiceURLMarker(integrationServiceConfig);
                IntegrationContextManager contextManager = this.getContextManager(integrationServiceConfig);
                contextManager.initializeContextManager(partnerOMASServerName, partnerOMASRootURL, this.localServerUserId, this.localServerPassword, this.maxPageSize, auditLog);
                contextManager.createClients();
                IntegrationServiceHandler integrationServiceHandler = new IntegrationServiceHandler(this.localServerName, integrationServiceConfig, contextManager, auditLog);
                List<IntegrationConnectorHandler> serviceConnectorHandlers = integrationServiceHandler.initialize();
                if (serviceConnectorHandlers != null) {
                    daemonConnectorHandlers.addAll(serviceConnectorHandlers);
                }
                integrationServiceHandlerMap.put(integrationServiceURLMarker, integrationServiceHandler);
            }
            IntegrationDaemonHandler integrationDaemonHandler = new IntegrationDaemonHandler(daemonConnectorHandlers);
            this.integrationDaemonInstance = new IntegrationDaemonInstance(this.localServerName, GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), auditLog, this.localServerUserId, this.maxPageSize, integrationDaemonHandler, integrationServiceHandlerMap);
            auditLog.logMessage("initialize", IntegrationDaemonServicesAuditCode.SERVER_INITIALIZED.getMessageDefinition(new String[]{this.localServerName}));
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        catch (Throwable error) {
            auditLog.logException("initialize", IntegrationDaemonServicesAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), error.toString(), error);
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), this.getClass().getName(), "initialize", error);
        }
    }

    private String getPartnerOMASRootURL(IntegrationServiceConfig integrationServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceRootURL = integrationServicesConfig.getOMAGServerPlatformRootURL();
        if (accessServiceRootURL == null) {
            String actionDescription = "Validate integration service configuration.";
            String methodName = "getAccessServiceRootURL";
            this.auditLog.logMessage("Validate integration service configuration.", IntegrationDaemonServicesAuditCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceRootURL");
        }
        return accessServiceRootURL;
    }

    private String getPartnerOMASServerName(IntegrationServiceConfig integrationServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceServerName = integrationServicesConfig.getOMAGServerName();
        if (accessServiceServerName == null) {
            String actionDescription = "Validate integration service configuration.";
            String methodName = "getAccessServiceServerName";
            this.auditLog.logMessage("Validate integration service configuration.", IntegrationDaemonServicesAuditCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceServerName");
        }
        return accessServiceServerName;
    }

    private IntegrationContextManager getContextManager(IntegrationServiceConfig integrationServiceConfig) throws OMAGConfigurationErrorException {
        String methodName = "getContextManager";
        String contextManagerClassName = integrationServiceConfig.getIntegrationServiceContextManagerClass();
        if (contextManagerClassName != null) {
            try {
                return (IntegrationContextManager)Class.forName(contextManagerClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException error) {
                this.auditLog.logException("getContextManager", IntegrationDaemonServicesAuditCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), integrationServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getContextManager", (Throwable)error);
            }
            catch (Throwable error) {
                this.auditLog.logException("getContextManager", IntegrationDaemonServicesAuditCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), integrationServiceConfig.toString(), error);
                throw error;
            }
        }
        this.auditLog.logMessage("getContextManager", IntegrationDaemonServicesAuditCode.NULL_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), integrationServiceConfig.toString());
        throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "getContextManager");
    }

    private String getServiceURLMarker(IntegrationServiceConfig integrationServiceConfig) throws OMAGConfigurationErrorException {
        String methodName = "getServiceURLMarker";
        String serviceNamePropertyName = "integrationServiceName";
        String serviceFullNamePropertyName = "integrationServiceFullName";
        String serviceURLMarkerPropertyName = "integrationServiceURLMarker";
        String unknownValue = "???";
        if ("".equals(integrationServiceConfig.getIntegrationServiceName()) || integrationServiceConfig.getIntegrationServiceName() == null) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceName", "???", this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        if ("".equals(integrationServiceConfig.getIntegrationServiceFullName()) || integrationServiceConfig.getIntegrationServiceFullName() == null) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceFullName", integrationServiceConfig.getIntegrationServiceName(), this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        if ("".equals(integrationServiceConfig.getIntegrationServiceURLMarker()) || integrationServiceConfig.getIntegrationServiceURLMarker() == null) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceURLMarker", integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        return integrationServiceConfig.getIntegrationServiceURLMarker();
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", IntegrationDaemonServicesAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.integrationDaemonInstance.shutdown();
        this.auditLog.logMessage("terminate", IntegrationDaemonServicesAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

