/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads.IntegrationConnectorDedicatedThread;

public class IntegrationConnectorHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String integrationServiceFullName;
    private Map<String, Object> integrationServiceOptions;
    private String integrationDaemonName;
    private String integrationConnectorId;
    private String integrationConnectorName;
    private String metadataSourceQualifiedName;
    private PermittedSynchronization permittedSynchronization;
    private Connection connection;
    private boolean needDedicatedThread;
    private long minSecondsBetweenRefresh;
    private IntegrationContextManager contextManager;
    private AuditLog auditLog;
    private IntegrationConnector integrationConnector = null;
    private IntegrationConnectorDedicatedThread integrationConnectorDedicatedThread = null;
    private IntegrationConnectorStatus integrationConnectorStatus = null;
    private Date lastStatusChange = null;
    private String failingExceptionMessage = null;
    private Map<String, Object> statistics = null;
    private Date lastRefreshTime = null;

    IntegrationConnectorHandler(IntegrationConnectorConfig integrationConnectorConfig, String integrationServiceFullName, Map<String, Object> integrationServiceOptions, String integrationDaemonName, IntegrationContextManager contextManager, AuditLog auditLog) {
        String actionDescription = "Initializing integration connector";
        this.integrationServiceFullName = integrationServiceFullName;
        this.integrationServiceOptions = integrationServiceOptions;
        this.integrationDaemonName = integrationDaemonName;
        this.integrationConnectorId = integrationConnectorConfig.getConnectorId();
        this.integrationConnectorName = integrationConnectorConfig.getConnectorName();
        this.metadataSourceQualifiedName = integrationConnectorConfig.getMetadataSourceQualifiedName();
        this.minSecondsBetweenRefresh = integrationConnectorConfig.getRefreshTimeInterval();
        this.connection = integrationConnectorConfig.getConnection();
        this.needDedicatedThread = integrationConnectorConfig.getUsesBlockingCalls();
        this.permittedSynchronization = integrationConnectorConfig.getPermittedSynchronization();
        this.contextManager = contextManager;
        this.auditLog = auditLog;
        this.reinitializeConnector("Initializing integration connector");
    }

    public String getIntegrationConnectorName() {
        return this.integrationConnectorName;
    }

    IntegrationConnectorStatus getIntegrationConnectorStatus() {
        return this.integrationConnectorStatus;
    }

    Date getLastStatusChange() {
        return this.lastStatusChange;
    }

    String getFailingExceptionMessage() {
        return this.failingExceptionMessage;
    }

    Map<String, Object> getStatistics() {
        return this.statistics;
    }

    public Date getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    public long getMinSecondsBetweenRefresh() {
        return this.minSecondsBetweenRefresh;
    }

    private Connector getConnector(Connection connection, String actionDescription) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
        try {
            return connectorBroker.getConnector(connection);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException error) {
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.BAD_INTEGRATION_CONNECTION.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationServiceFullName, error.getClass().getName(), error.getMessage()}));
            throw error;
        }
    }

    void reinitializeConnector(String actionDescription) {
        String operationName = "initialize";
        this.disconnectConnector(actionDescription);
        this.resetConnectorHandler();
        this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.INTEGRATION_CONNECTOR_INITIALIZING.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationServiceFullName, this.integrationDaemonName, this.permittedSynchronization.getName()}));
        Connector genericConnector = null;
        try {
            genericConnector = this.getConnector(this.connection, actionDescription);
            this.integrationConnector = (IntegrationConnector)genericConnector;
            this.updateStatus(IntegrationConnectorStatus.INITIALIZED);
            this.contextManager.setContext(this.integrationConnectorId, this.integrationConnectorName, this.metadataSourceQualifiedName, this.integrationConnector, this.permittedSynchronization, this.integrationServiceOptions);
            if (this.needDedicatedThread) {
                this.integrationConnectorDedicatedThread = new IntegrationConnectorDedicatedThread(this.integrationDaemonName, this, this.auditLog);
                this.integrationConnectorDedicatedThread.start();
            }
        }
        catch (ClassCastException error) {
            String connectorClassName = null;
            if (genericConnector != null) {
                connectorClassName = genericConnector.getClass().getName();
            }
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.NOT_INTEGRATION_CONNECTOR.getMessageDefinition(new String[]{this.integrationConnectorName, connectorClassName, IntegrationConnector.class.getCanonicalName()}));
            this.processConnectorException(actionDescription, "initialize", error);
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "initialize", error);
        }
    }

    public synchronized void engageConnector(String actionDescription) {
        String operationName = "engage";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                this.startConnector(actionDescription);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.RUNNING) {
                this.integrationConnector.engage();
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "engage", error);
        }
    }

    public synchronized void refreshConnector(String actionDescription) {
        String operationName = "refresh";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                this.startConnector(actionDescription);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.RUNNING) {
                this.integrationConnector.refresh();
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "refresh", error);
        }
    }

    public synchronized void shutdown(String actionDescription) {
        this.disconnectConnector(actionDescription);
        this.resetConnectorHandler();
    }

    private void startConnector(String actionDescription) {
        String operationName = "start";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                this.integrationConnector.start();
                this.updateStatus(IntegrationConnectorStatus.RUNNING);
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "start", error);
        }
    }

    private void disconnectConnector(String actionDescription) {
        String operationName = "disconnect";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.RUNNING || this.integrationConnectorStatus == IntegrationConnectorStatus.FAILED) {
                this.integrationConnector.disconnect();
                this.updateStatus(IntegrationConnectorStatus.STOPPED);
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "disconnect", error);
        }
    }

    private void resetConnectorHandler() {
        if (this.integrationConnectorDedicatedThread != null) {
            this.integrationConnectorDedicatedThread.stop();
        }
        this.updateStatus(null);
        this.integrationConnector = null;
        this.integrationConnectorDedicatedThread = null;
        this.failingExceptionMessage = null;
        this.statistics = null;
        this.lastRefreshTime = null;
    }

    private void processConnectorException(String actionDescription, String operationName, Exception error) {
        this.updateStatus(IntegrationConnectorStatus.FAILED);
        this.failingExceptionMessage = error.getMessage();
        this.auditLog.logException(actionDescription, IntegrationDaemonServicesAuditCode.CONNECTOR_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, operationName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
    }

    private void updateStatus(IntegrationConnectorStatus newStatus) {
        if (newStatus == null) {
            this.integrationConnectorStatus = null;
            this.lastStatusChange = null;
        } else {
            this.integrationConnectorStatus = newStatus;
            this.lastStatusChange = new Date();
        }
    }
}

