/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.slf4j.LoggerFactory;

public class IntegrationDaemonRESTServices {
    private static IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationDaemonRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse refreshAllServices(String serverName, String userId, NullRequestBody requestBody) {
        String methodName = "refreshAllServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshAllServices");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshAllServices");
            List<IntegrationServiceHandler> handlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "refreshAllServices");
            if (handlers != null) {
                for (IntegrationServiceHandler handler : handlers) {
                    if (handler == null) continue;
                    handler.refreshService(userId);
                }
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "refreshAllServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshService(String serverName, String userId, String serviceURLMarker, String connectorName) {
        String methodName = "refreshService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "refreshService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshService");
            handler.refreshService(connectorName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "refreshService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartService(String serverName, String userId, String serviceURLMarker, String connectorName) {
        String methodName = "restartService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restartService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "restartService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartService");
            handler.restartService(connectorName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "restartService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(String serverName, String userId) {
        String methodName = "getIntegrationDaemonStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse response = new IntegrationDaemonStatusResponse();
        AuditLog auditLog = null;
        try {
            List<IntegrationServiceHandler> handlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationDaemonStatus");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationDaemonStatus");
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (handlers != null) {
                for (IntegrationServiceHandler handler : handlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                response.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getIntegrationDaemonStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

