/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationDaemonThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IntegrationDaemonThread.class);
    private String integrationDaemonName;
    private List<IntegrationConnectorHandler> connectorHandlers;
    private AuditLog auditLog;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public IntegrationDaemonThread(String integrationDaemonName, List<IntegrationConnectorHandler> connectorHandlers, AuditLog auditLog) {
        this.integrationDaemonName = integrationDaemonName;
        this.connectorHandlers = connectorHandlers;
        this.auditLog = auditLog;
    }

    public void start() {
        String threadName = "::IntegrationDaemonThread";
        Thread worker = new Thread((Runnable)this, this.integrationDaemonName + "::IntegrationDaemonThread");
        worker.start();
    }

    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        String actionDescription = "Periodic refresh of connector";
        this.running.set(true);
        this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.DAEMON_THREAD_STARTING.getMessageDefinition(new String[]{this.integrationDaemonName}));
        while (this.running.get()) {
            Date now = new Date();
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                long nextRefreshTime;
                if (connectorHandler == null) continue;
                if (connectorHandler.getLastRefreshTime() == null) {
                    this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_FIRST_REFRESH.getMessageDefinition(new String[]{connectorHandler.getIntegrationConnectorName(), this.integrationDaemonName}));
                    connectorHandler.refreshConnector("Periodic refresh of connector");
                    continue;
                }
                if (connectorHandler.getMinSecondsBetweenRefresh() <= 0L || (nextRefreshTime = connectorHandler.getLastRefreshTime().getTime() + connectorHandler.getMinSecondsBetweenRefresh() * 1000L) >= now.getTime()) continue;
                this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_REFRESH.getMessageDefinition(new String[]{connectorHandler.getIntegrationConnectorName(), this.integrationDaemonName}));
                connectorHandler.refreshConnector("Periodic refresh of connector");
            }
            this.waitToRetry();
        }
        this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.DAEMON_THREAD_TERMINATING.getMessageDefinition(new String[]{this.integrationDaemonName}));
    }

    private void waitToRetry() {
        int sleepTime = 1000;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception error) {
            log.error("Ignored exception from sleep - probably ok", (Throwable)error);
        }
    }
}

