/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstance;
import org.odpi.openmetadata.integrationservices.catalogintegrator.contextmanager.CatalogIntegratorContextManager;
import org.odpi.openmetadata.integrationservices.database.contextmanager.DatabaseIntegratorContextManager;
import org.odpi.openmetadata.integrationservices.files.contextmanager.FilesIntegratorContextManager;
import org.odpi.openmetadata.integrationservices.lineageintegrator.contextmanager.LineageIntegratorContextManager;
import org.odpi.openmetadata.integrationservices.organizationintegrator.contextmanager.OrganizationIntegratorContextManager;
import org.odpi.openmetadata.integrationservices.securityintegrator.contextmanager.SecurityIntegratorContextManager;

class IntegrationDaemonInstanceHandler
extends GovernanceServerServiceInstanceHandler {
    IntegrationDaemonInstanceHandler() {
        super(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS, (String)CatalogIntegratorContextManager.class.getName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.DATABASE_INTEGRATOR_OMIS, (String)DatabaseIntegratorContextManager.class.getName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.FILES_INTEGRATOR_OMIS, (String)FilesIntegratorContextManager.class.getName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.LINEAGE_INTEGRATOR_OMIS, (String)LineageIntegratorContextManager.class.getName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.ORGANIZATION_INTEGRATOR_OMIS, (String)OrganizationIntegratorContextManager.class.getName());
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.SECURITY_INTEGRATOR_OMIS, (String)SecurityIntegratorContextManager.class.getName());
    }

    List<IntegrationServiceHandler> getAllIntegrationServiceHandlers(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getAllIntegrationServiceHandlers(serviceOperationName);
        }
        return null;
    }

    IntegrationServiceHandler getIntegrationServiceHandler(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationServiceHandler(serviceURLMarker, serviceOperationName);
        }
        return null;
    }
}

