/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.properties.OMAGServerServiceStatus;
import org.odpi.openmetadata.adminservices.properties.ServerActiveStatus;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstance;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads.IntegrationDaemonThread;

public class IntegrationDaemonOperationalServices {
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private AuditLog auditLog = null;
    private IntegrationDaemonInstance integrationDaemonInstance = null;
    private Map<String, ServerActiveStatus> serviceStatusMap = new HashMap<String, ServerActiveStatus>();

    public IntegrationDaemonOperationalServices(String localServerName, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
    }

    public List<String> initialize(List<IntegrationServiceConfig> configuration, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize", IntegrationDaemonServicesAuditCode.SERVER_INITIALIZING.getMessageDefinition(new String[]{this.localServerName}));
        try {
            if (configuration == null) {
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_CONFIG_DOC.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            if (configuration.isEmpty()) {
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_INTEGRATION_SERVICES_CONFIGURED.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            ArrayList<IntegrationConnectorHandler> daemonConnectorHandlers = new ArrayList<IntegrationConnectorHandler>();
            HashMap<String, IntegrationServiceHandler> integrationServiceHandlerMap = new HashMap<String, IntegrationServiceHandler>();
            for (IntegrationServiceConfig integrationServiceConfig : configuration) {
                if (integrationServiceConfig == null) continue;
                this.setServerServiceActiveStatus(integrationServiceConfig.getIntegrationServiceFullName(), ServerActiveStatus.STARTING);
                String partnerOMASRootURL = this.getPartnerOMASRootURL(integrationServiceConfig);
                String partnerOMASServerName = this.getPartnerOMASServerName(integrationServiceConfig);
                String integrationServiceURLMarker = this.getServiceURLMarker(integrationServiceConfig);
                IntegrationContextManager contextManager = this.getContextManager(integrationServiceConfig);
                if (integrationServiceConfig.getDefaultPermittedSynchronization() == null) {
                    auditLog.logMessage("initialize", IntegrationDaemonServicesAuditCode.NO_PERMITTED_SYNCHRONIZATION.getMessageDefinition(new String[]{this.localServerName}), integrationServiceConfig.toString());
                    throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_PERMITTED_SYNCHRONIZATION.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "initialize");
                }
                AuditLog integrationServicesAuditLog = auditLog.createNewAuditLog(integrationServiceConfig.getIntegrationServiceId(), integrationServiceConfig.getIntegrationServiceDevelopmentStatus(), integrationServiceConfig.getIntegrationServiceFullName(), integrationServiceConfig.getIntegrationServiceDescription(), integrationServiceConfig.getIntegrationServiceWiki());
                contextManager.initializeContextManager(partnerOMASServerName, partnerOMASRootURL, this.localServerUserId, this.localServerPassword, integrationServiceConfig.getIntegrationServiceOptions(), this.maxPageSize, integrationServicesAuditLog);
                contextManager.createClients();
                IntegrationServiceHandler integrationServiceHandler = new IntegrationServiceHandler(this.localServerName, integrationServiceConfig, contextManager, auditLog);
                List<IntegrationConnectorHandler> serviceConnectorHandlers = integrationServiceHandler.initialize();
                if (serviceConnectorHandlers != null) {
                    daemonConnectorHandlers.addAll(serviceConnectorHandlers);
                }
                integrationServiceHandlerMap.put(integrationServiceURLMarker, integrationServiceHandler);
                this.setServerServiceActiveStatus(integrationServiceConfig.getIntegrationServiceFullName(), ServerActiveStatus.RUNNING);
            }
            IntegrationDaemonThread integrationDaemonThread = new IntegrationDaemonThread(this.localServerName, daemonConnectorHandlers, auditLog);
            integrationDaemonThread.start();
            this.integrationDaemonInstance = new IntegrationDaemonInstance(this.localServerName, GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName(), auditLog, this.localServerUserId, this.maxPageSize, integrationDaemonThread, integrationServiceHandlerMap);
            auditLog.logMessage("initialize", IntegrationDaemonServicesAuditCode.SERVER_INITIALIZED.getMessageDefinition(new String[]{this.localServerName}));
            return new ArrayList<String>(this.serviceStatusMap.keySet());
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", IntegrationDaemonServicesAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), this.getClass().getName(), "initialize", (Throwable)error);
        }
    }

    private synchronized void setServerServiceActiveStatus(String serviceName, ServerActiveStatus activeStatus) {
        this.serviceStatusMap.put(serviceName, activeStatus);
    }

    public List<OMAGServerServiceStatus> getServiceStatuses() {
        ArrayList<OMAGServerServiceStatus> serviceStatuses = new ArrayList<OMAGServerServiceStatus>();
        for (String serviceName : this.serviceStatusMap.keySet()) {
            OMAGServerServiceStatus serviceStatus = new OMAGServerServiceStatus();
            serviceStatus.setServiceName(serviceName);
            serviceStatus.setServiceStatus(this.serviceStatusMap.get(serviceName));
            serviceStatuses.add(serviceStatus);
        }
        return serviceStatuses;
    }

    private String getPartnerOMASRootURL(IntegrationServiceConfig integrationServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceRootURL = integrationServicesConfig.getOMAGServerPlatformRootURL();
        if (accessServiceRootURL == null) {
            String actionDescription = "Validate integration service configuration.";
            String methodName = "getAccessServiceRootURL";
            this.auditLog.logMessage("Validate integration service configuration.", IntegrationDaemonServicesAuditCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceRootURL");
        }
        return accessServiceRootURL;
    }

    private String getPartnerOMASServerName(IntegrationServiceConfig integrationServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceServerName = integrationServicesConfig.getOMAGServerName();
        if (accessServiceServerName == null) {
            String actionDescription = "Validate integration service configuration.";
            String methodName = "getAccessServiceServerName";
            this.auditLog.logMessage("Validate integration service configuration.", IntegrationDaemonServicesAuditCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceServerName");
        }
        return accessServiceServerName;
    }

    private IntegrationContextManager getContextManager(IntegrationServiceConfig integrationServiceConfig) throws OMAGConfigurationErrorException {
        String methodName = "getContextManager";
        String contextManagerClassName = integrationServiceConfig.getIntegrationServiceContextManagerClass();
        if (contextManagerClassName != null) {
            try {
                return (IntegrationContextManager)Class.forName(contextManagerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
                this.auditLog.logException("getContextManager", IntegrationDaemonServicesAuditCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), integrationServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getContextManager", (Throwable)error);
            }
            catch (Exception error) {
                this.auditLog.logException("getContextManager", IntegrationDaemonServicesAuditCode.INVALID_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), contextManagerClassName, error.getClass().getName(), error.getMessage()}), integrationServiceConfig.toString(), (Throwable)error);
                throw error;
            }
        }
        this.auditLog.logMessage("getContextManager", IntegrationDaemonServicesAuditCode.NULL_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), integrationServiceConfig.toString());
        throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_CONTEXT_MANAGER.getMessageDefinition(new String[]{integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "getContextManager");
    }

    private String getServiceURLMarker(IntegrationServiceConfig integrationServiceConfig) throws OMAGConfigurationErrorException {
        String methodName = "getServiceURLMarker";
        String serviceNamePropertyName = "integrationServiceName";
        String serviceFullNamePropertyName = "integrationServiceFullName";
        String serviceURLMarkerPropertyName = "integrationServiceURLMarker";
        String unknownValue = "???";
        if (integrationServiceConfig.getIntegrationServiceName() == null || integrationServiceConfig.getIntegrationServiceName().length() == 0) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceName", "???", this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        if (integrationServiceConfig.getIntegrationServiceFullName() == null || integrationServiceConfig.getIntegrationServiceFullName().length() == 0) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceFullName", integrationServiceConfig.getIntegrationServiceName(), this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        if (integrationServiceConfig.getIntegrationServiceURLMarker() == null || integrationServiceConfig.getIntegrationServiceURLMarker().length() == 0) {
            throw new OMAGConfigurationErrorException(IntegrationDaemonServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{"integrationServiceURLMarker", integrationServiceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "getServiceURLMarker");
        }
        return integrationServiceConfig.getIntegrationServiceURLMarker();
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", IntegrationDaemonServicesAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        for (String serviceName : this.serviceStatusMap.keySet()) {
            this.serviceStatusMap.put(serviceName, ServerActiveStatus.STOPPING);
        }
        if (this.integrationDaemonInstance != null) {
            this.integrationDaemonInstance.shutdown();
        }
        for (String serviceName : this.serviceStatusMap.keySet()) {
            this.serviceStatusMap.put(serviceName, ServerActiveStatus.INACTIVE);
        }
        this.auditLog.logMessage("terminate", IntegrationDaemonServicesAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

