/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads.IntegrationDaemonThread;

public class IntegrationDaemonInstance
extends GovernanceServerServiceInstance {
    private IntegrationDaemonThread integrationDaemonThread;
    private Map<String, IntegrationServiceHandler> integrationServiceHandlers;

    IntegrationDaemonInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, IntegrationDaemonThread integrationDaemonThread, Map<String, IntegrationServiceHandler> integrationServiceHandlers) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize);
        this.integrationDaemonThread = integrationDaemonThread;
        this.integrationServiceHandlers = integrationServiceHandlers;
    }

    synchronized List<IntegrationServiceHandler> getAllIntegrationServiceHandlers(String serviceOperationName) throws PropertyServerException {
        if (this.integrationServiceHandlers == null || this.integrationServiceHandlers.isEmpty()) {
            throw new PropertyServerException(IntegrationDaemonServicesErrorCode.NO_INTEGRATION_SERVICES.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        return new ArrayList<IntegrationServiceHandler>(this.integrationServiceHandlers.values());
    }

    synchronized IntegrationServiceHandler getIntegrationServiceHandler(String serviceURLMarker, String serviceOperationName) throws InvalidParameterException {
        String nameParameterName = "serviceURLMarker";
        IntegrationServiceHandler handler = this.integrationServiceHandlers.get(serviceURLMarker);
        if (handler == null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_INTEGRATION_SERVICE.getMessageDefinition(new String[]{this.serverName, serviceURLMarker}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "serviceURLMarker");
        }
        return handler;
    }

    public void shutdown() {
        if (this.integrationServiceHandlers != null && !this.integrationServiceHandlers.isEmpty()) {
            for (IntegrationServiceHandler handler : this.integrationServiceHandlers.values()) {
                if (handler == null) continue;
                handler.shutdown();
            }
        }
        if (this.integrationDaemonThread != null) {
            this.integrationDaemonThread.stop();
        }
        super.shutdown();
    }
}

