/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads;

import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationConnectorDedicatedThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IntegrationConnectorDedicatedThread.class);
    private String integrationDaemonName;
    private IntegrationConnectorHandler connectorHandler;
    private AuditLog auditLog;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public IntegrationConnectorDedicatedThread(String integrationDaemonName, IntegrationConnectorHandler connectorHandler, AuditLog auditLog) {
        this.integrationDaemonName = integrationDaemonName;
        this.connectorHandler = connectorHandler;
        this.auditLog = auditLog;
    }

    public void start() {
        String threadName = "::DedicatedConnectorThread::";
        Thread worker = new Thread((Runnable)this, this.integrationDaemonName + "::DedicatedConnectorThread::" + this.connectorHandler.getIntegrationConnectorName());
        worker.start();
    }

    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        String actionDescription = "Run dedicated connector thread";
        this.running.set(true);
        this.auditLog.logMessage("Run dedicated connector thread", IntegrationDaemonServicesAuditCode.CONNECTOR_THREAD_STARTING.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName(), this.integrationDaemonName}));
        while (this.running.get()) {
            this.connectorHandler.engageConnector("Run dedicated connector thread");
            this.auditLog.logMessage("Run dedicated connector thread", IntegrationDaemonServicesAuditCode.ENGAGE_RETURNED.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName(), this.integrationDaemonName}));
            this.waitToRetry();
        }
        this.auditLog.logMessage("Run dedicated connector thread", IntegrationDaemonServicesAuditCode.CONNECTOR_THREAD_TERMINATING.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName(), this.integrationDaemonName}));
    }

    private void waitToRetry() {
        long sleepTime = 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception error) {
            log.error("Ignored exception from sleep - probably ok", (Throwable)error);
        }
    }
}

