/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;

public class IntegrationConnectorCacheMap {
    private volatile Map<String, IntegrationConnectorHandler> integrationConnectorLookupTable = new HashMap<String, IntegrationConnectorHandler>();
    private volatile List<IntegrationConnectorHandler> integrationConnectorProcessingList = new ArrayList<IntegrationConnectorHandler>();

    synchronized void clear() {
        this.integrationConnectorLookupTable = new HashMap<String, IntegrationConnectorHandler>();
        this.integrationConnectorProcessingList = new ArrayList<IntegrationConnectorHandler>();
    }

    public synchronized void putHandlerByConnectorId(String connectorId, IntegrationConnectorHandler integrationConnectorHandler) {
        this.integrationConnectorLookupTable.put(connectorId, integrationConnectorHandler);
        if (!integrationConnectorHandler.needsDedicatedThread()) {
            this.integrationConnectorProcessingList.add(0, integrationConnectorHandler);
        }
    }

    public synchronized IntegrationConnectorHandler getHandlerByConnectorId(String connectorId) {
        return this.integrationConnectorLookupTable.get(connectorId);
    }

    public synchronized List<String> getConnectorIds() {
        if (this.integrationConnectorLookupTable.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.integrationConnectorLookupTable.keySet());
    }

    public synchronized List<IntegrationConnectorHandler> getIntegrationConnectorProcessingList() {
        if (this.integrationConnectorProcessingList.isEmpty()) {
            return null;
        }
        return new ArrayList<IntegrationConnectorHandler>(this.integrationConnectorProcessingList);
    }
}

