/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.IntegrationGroupConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationGroupElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorCacheMap;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;

public class IntegrationGroupHandler {
    protected String serverName;
    protected String serverUserId;
    protected GovernanceEngineClient serverClient;
    protected AuditLog auditLog;
    protected int maxPageSize;
    protected String integrationGroupName;
    protected String integrationGroupGUID = null;
    protected IntegrationGroupProperties integrationGroupProperties = null;
    private IntegrationGroupElement integrationGroupElement = null;
    private final IntegrationGroupConfigurationClient configurationClient;
    private final IntegrationConnectorCacheMap integrationConnectorLookupTable;
    private final Map<String, IntegrationServiceHandler> integrationServiceHandlerMap;
    private final List<IntegrationConnectorHandler> connectorHandlers = new ArrayList<IntegrationConnectorHandler>();

    public IntegrationGroupHandler(String integrationGroupName, Map<String, IntegrationServiceHandler> integrationServiceHandlerMap, IntegrationConnectorCacheMap integrationConnectorCacheMap, String serverName, String serverUserId, IntegrationGroupConfigurationClient configurationClient, GovernanceEngineClient serverClient, AuditLog auditLog, int maxPageSize) {
        this.integrationGroupName = integrationGroupName;
        this.integrationServiceHandlerMap = integrationServiceHandlerMap;
        this.integrationConnectorLookupTable = integrationConnectorCacheMap;
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.configurationClient = configurationClient;
        this.serverClient = serverClient;
        this.auditLog = auditLog;
        this.maxPageSize = maxPageSize;
    }

    public String getIntegrationGroupName() {
        return this.integrationGroupName;
    }

    public synchronized IntegrationGroupSummary getSummary() {
        IntegrationGroupSummary mySummary = new IntegrationGroupSummary();
        mySummary.setIntegrationGroupName(this.integrationGroupName);
        mySummary.setIntegrationGroupGUID(this.integrationGroupGUID);
        if (this.integrationGroupProperties != null) {
            mySummary.setIntegrationGroupDescription(this.integrationGroupProperties.getDescription());
        }
        ArrayList<IntegrationConnectorReport> connectorReports = new ArrayList<IntegrationConnectorReport>();
        if (!this.connectorHandlers.isEmpty()) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                IntegrationConnectorReport connectorReport = new IntegrationConnectorReport();
                connectorReport.setConnectorId(connectorHandler.getIntegrationConnectorId());
                connectorReport.setConnectorName(connectorHandler.getIntegrationConnectorName());
                connectorReport.setConnectorStatus(connectorHandler.getIntegrationConnectorStatus());
                connectorReport.setConnection(connectorHandler.getConnection());
                connectorReport.setConnectorInstanceId(connectorHandler.getIntegrationConnectorInstanceId());
                connectorReport.setFailingExceptionMessage(connectorHandler.getFailingExceptionMessage());
                connectorReport.setStatistics(connectorHandler.getStatistics());
                connectorReport.setLastStatusChange(connectorHandler.getLastStatusChange());
                connectorReport.setLastRefreshTime(connectorHandler.getLastRefreshTime());
                connectorReport.setMinMinutesBetweenRefresh(connectorHandler.getMinMinutesBetweenRefresh());
                connectorReports.add(connectorReport);
            }
        }
        if (!connectorReports.isEmpty()) {
            mySummary.setIntegrationConnectorReports(connectorReports);
        }
        mySummary.setIntegrationGroupStatus(IntegrationGroupStatus.ASSIGNED);
        if (this.integrationGroupGUID != null) {
            mySummary.setIntegrationGroupStatus(IntegrationGroupStatus.CONFIGURING);
        }
        if (!this.connectorHandlers.isEmpty()) {
            mySummary.setIntegrationGroupStatus(IntegrationGroupStatus.RUNNING);
        }
        return mySummary;
    }

    public synchronized String getIntegrationGroupGUID() {
        return this.integrationGroupGUID;
    }

    public synchronized void refreshConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        this.integrationGroupElement = this.configurationClient.getIntegrationGroupByName(this.serverUserId, this.integrationGroupName);
        if (this.integrationGroupElement == null || this.integrationGroupElement.getElementHeader() == null || this.integrationGroupElement.getElementHeader().getType() == null || this.integrationGroupElement.getProperties() == null) {
            this.integrationGroupGUID = null;
            this.integrationGroupProperties = null;
            throw new PropertyServerException(IntegrationDaemonServicesErrorCode.UNKNOWN_GOVERNANCE_ENGINE_CONFIG.getMessageDefinition(new String[]{this.integrationGroupName, this.configurationClient.getConfigurationServerName(), this.serverName}), this.getClass().getName(), "refreshConfig");
        }
        this.integrationGroupGUID = this.integrationGroupElement.getElementHeader().getGUID();
        this.integrationGroupProperties = this.integrationGroupElement.getProperties();
        this.refreshAllConnectorConfig();
    }

    private void refreshAllConnectorConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAllConnectorConfig";
        String actionDescription = "Retrieve all integration connector configuration";
        this.auditLog.logMessage("Retrieve all integration connector configuration", IntegrationDaemonServicesAuditCode.CLEARING_ALL_GOVERNANCE_SERVICE_CONFIG.getMessageDefinition(new String[]{this.integrationGroupName}));
        this.integrationConnectorLookupTable.clear();
        int startingFrom = 0;
        boolean moreToReceive = true;
        while (moreToReceive) {
            List registeredIntegrationConnectors = this.configurationClient.getRegisteredIntegrationConnectors(this.serverUserId, this.integrationGroupGUID, startingFrom, this.maxPageSize);
            if (registeredIntegrationConnectors != null && !registeredIntegrationConnectors.isEmpty()) {
                for (RegisteredIntegrationConnectorElement registeredIntegrationConnectorElement : registeredIntegrationConnectors) {
                    this.refreshRegisteredIntegrationConnector(registeredIntegrationConnectorElement, "refreshAllConnectorConfig");
                }
                startingFrom += this.maxPageSize;
                continue;
            }
            moreToReceive = false;
        }
        this.auditLog.logMessage("Retrieve all integration connector configuration", IntegrationDaemonServicesAuditCode.FINISHED_ALL_INTEGRATION_CONNECTOR_CONFIG.getMessageDefinition(new String[]{this.integrationGroupName}));
    }

    public synchronized void refreshConnectorConfig(String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConnectorConfig";
        if (integrationConnectorGUID != null) {
            RegisteredIntegrationConnectorElement registeredIntegrationConnector = this.configurationClient.getRegisteredIntegrationConnector(this.serverUserId, this.integrationGroupGUID, integrationConnectorGUID);
            this.refreshRegisteredIntegrationConnector(registeredIntegrationConnector, "refreshConnectorConfig");
        }
    }

    private void refreshRegisteredIntegrationConnector(RegisteredIntegrationConnectorElement registeredIntegrationConnectorElement, String methodName) {
        block7: {
            if (registeredIntegrationConnectorElement != null && registeredIntegrationConnectorElement.getConnectorId() != null && registeredIntegrationConnectorElement.getElementHeader() != null && registeredIntegrationConnectorElement.getRegistrationProperties() != null && registeredIntegrationConnectorElement.getProperties() != null && registeredIntegrationConnectorElement.getProperties().getConnection() != null && registeredIntegrationConnectorElement.getProperties().getConnection().getConnectorType() != null && registeredIntegrationConnectorElement.getProperties().getConnection().getConnectorType().getConnectorProviderClassName() != null) {
                IntegrationConnectorHandler connectorHandler = this.integrationConnectorLookupTable.getHandlerByConnectorId(registeredIntegrationConnectorElement.getConnectorId());
                if (connectorHandler == null) {
                    try {
                        String serviceURLMarker = IntegrationServiceRegistry.getIntegrationServiceURLMarker((String)registeredIntegrationConnectorElement.getProperties().getConnection().getConnectorType().getConnectorProviderClassName());
                        if (serviceURLMarker != null) {
                            IntegrationServiceHandler integrationServiceHandler = this.integrationServiceHandlerMap.get(serviceURLMarker);
                            String userId = this.serverUserId;
                            if (registeredIntegrationConnectorElement.getRegistrationProperties().getConnectorUserId() != null) {
                                userId = registeredIntegrationConnectorElement.getRegistrationProperties().getConnectorUserId();
                            }
                            connectorHandler = new IntegrationConnectorHandler(registeredIntegrationConnectorElement.getConnectorId(), registeredIntegrationConnectorElement.getElementHeader().getGUID(), registeredIntegrationConnectorElement.getRegistrationProperties().getConnectorName(), userId, registeredIntegrationConnectorElement.getRegistrationProperties().getStartDate(), registeredIntegrationConnectorElement.getRegistrationProperties().getStopDate(), registeredIntegrationConnectorElement.getRegistrationProperties().getRefreshTimeInterval(), registeredIntegrationConnectorElement.getRegistrationProperties().getMetadataSourceQualifiedName(), registeredIntegrationConnectorElement.getProperties().getConnection(), registeredIntegrationConnectorElement.getProperties().getUsesBlockingCalls(), registeredIntegrationConnectorElement.getRegistrationProperties().getPermittedSynchronization(), registeredIntegrationConnectorElement.getRegistrationProperties().getGenerateIntegrationReports(), integrationServiceHandler.getIntegrationServiceFullName(), this.serverName, integrationServiceHandler.getContextManager(), this.auditLog);
                            this.connectorHandlers.add(connectorHandler);
                            this.integrationConnectorLookupTable.putHandlerByConnectorId(registeredIntegrationConnectorElement.getConnectorId(), connectorHandler);
                            break block7;
                        }
                        this.auditLog.logMessage(methodName, IntegrationDaemonServicesAuditCode.UNKNOWN_CONNECTOR_INTERFACE.getMessageDefinition(new String[]{registeredIntegrationConnectorElement.getElementHeader().getGUID()}), registeredIntegrationConnectorElement.toString());
                    }
                    catch (Exception error) {
                        this.auditLog.logException(methodName, IntegrationDaemonServicesAuditCode.CONNECTOR_CHANGE_FAILED.getMessageDefinition(new String[]{registeredIntegrationConnectorElement.getElementHeader().getGUID(), error.getClass().getName(), error.getMessage()}), registeredIntegrationConnectorElement.toString(), (Throwable)error);
                    }
                } else {
                    connectorHandler.updateConnectorDetails(registeredIntegrationConnectorElement);
                }
            }
        }
    }
}

