/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.listener;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.client.IntegrationGroupConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;

public class GovernanceEngineOutTopicListener
extends GovernanceEngineEventListener {
    private final Map<String, IntegrationGroupHandler> integrationGroupHandlers;
    private final IntegrationGroupConfigurationClient configurationClient;
    private final String userId;
    private final AuditLog auditLog;

    public GovernanceEngineOutTopicListener(Map<String, IntegrationGroupHandler> integrationGroupHandlers, IntegrationGroupConfigurationClient configurationClient, String userId, AuditLog auditLog) {
        this.integrationGroupHandlers = integrationGroupHandlers;
        this.configurationClient = configurationClient;
        this.userId = userId;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        String actionDescription = "Process OutTopic event";
        if (event != null && event instanceof WatchdogGovernanceServiceEvent) {
            WatchdogRelatedElementsEvent watchdogMetadataElementEvent;
            String elementTypeName;
            WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event;
            if (watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent() instanceof WatchdogClassificationEvent) {
                WatchdogClassificationEvent watchdogClassificationEvent = (WatchdogClassificationEvent)watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                String elementTypeName2 = watchdogClassificationEvent.getMetadataElement().getType().getTypeName();
                if (elementTypeName2.equals("IntegrationGroup")) {
                    this.processIntegrationGroupEvent(watchdogClassificationEvent.getMetadataElement(), watchdogGovernanceServiceEvent);
                } else if (elementTypeName2.equals("IntegrationConnector")) {
                    this.processIntegrationConnectorEvent(watchdogClassificationEvent.getMetadataElement().getElementGUID(), watchdogGovernanceServiceEvent);
                }
            } else if (watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent() instanceof WatchdogMetadataElementEvent) {
                WatchdogMetadataElementEvent watchdogMetadataElementEvent2 = (WatchdogMetadataElementEvent)watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                String elementTypeName3 = watchdogMetadataElementEvent2.getMetadataElement().getType().getTypeName();
                if (elementTypeName3.equals("IntegrationGroup")) {
                    this.processIntegrationGroupEvent(watchdogMetadataElementEvent2.getMetadataElement(), watchdogGovernanceServiceEvent);
                } else if (elementTypeName3.equals("IntegrationConnector")) {
                    this.processIntegrationConnectorEvent(watchdogMetadataElementEvent2.getMetadataElement().getElementGUID(), watchdogGovernanceServiceEvent);
                }
            } else if (watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent() instanceof WatchdogRelatedElementsEvent && (elementTypeName = (watchdogMetadataElementEvent = (WatchdogRelatedElementsEvent)watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent()).getRelatedMetadataElements().getType().getTypeName()).equals("RegisteredIntegrationConnector")) {
                this.processIntegrationConnectorEvent(watchdogMetadataElementEvent.getRelatedMetadataElements().getElementGUIDAtEnd2(), watchdogGovernanceServiceEvent);
            }
        }
    }

    private void processIntegrationGroupEvent(OpenMetadataElement integrationGroup, WatchdogGovernanceServiceEvent event) {
        IntegrationGroupHandler integrationGroupHandler;
        String actionDescription = "processIntegrationGroupEvent";
        PropertyValue elementQualifiedName = integrationGroup.getElementProperties().getPropertyValue("qualifiedName");
        if (elementQualifiedName != null && (integrationGroupHandler = this.integrationGroupHandlers.get(elementQualifiedName.valueAsString())) != null) {
            try {
                integrationGroupHandler.refreshConfig();
            }
            catch (Exception error) {
                this.auditLog.logException("processIntegrationGroupEvent", IntegrationDaemonServicesAuditCode.GROUP_CHANGE_FAILED.getMessageDefinition(new String[]{elementQualifiedName.valueAsString(), error.getClass().getName(), error.getMessage()}), event.toString(), (Throwable)error);
            }
        }
    }

    private void processIntegrationConnectorEvent(String integrationConnectorGUID, WatchdogGovernanceServiceEvent event) {
        String actionDescription = "processIntegrationConnectorEvent";
        try {
            List registrations = this.configurationClient.getIntegrationConnectorRegistrations(this.userId, integrationConnectorGUID);
            if (registrations != null) {
                for (String groupGUID : registrations) {
                    if (groupGUID == null) continue;
                    for (IntegrationGroupHandler handler : this.integrationGroupHandlers.values()) {
                        if (!groupGUID.equals(handler.getIntegrationGroupGUID())) continue;
                        handler.refreshConnectorConfig(integrationConnectorGUID);
                    }
                }
            }
        }
        catch (Exception error) {
            String eventString = null;
            if (event != null) {
                eventString = event.toString();
            }
            this.auditLog.logException("processIntegrationConnectorEvent", IntegrationDaemonServicesAuditCode.CONNECTOR_CHANGE_FAILED.getMessageDefinition(new String[]{integrationConnectorGUID, error.getClass().getName(), error.getMessage()}), eventString, (Throwable)error);
        }
    }
}

