/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationDaemonStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummariesResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationServiceSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.slf4j.LoggerFactory;

public class IntegrationDaemonRESTServices {
    private static final IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationDaemonRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public PropertiesResponse getConfigurationProperties(String serverName, String userId, String serviceURLMarker, String connectorName) {
        String methodName = "getConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfigurationProperties");
        PropertiesResponse response = new PropertiesResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "getConfigurationProperties");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfigurationProperties");
            response.setProperties(handler.getConfigurationProperties(userId, connectorName));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConfigurationProperties(String serverName, String userId, String serviceURLMarker, ConnectorConfigPropertiesRequestBody requestBody) {
        String methodName = "updateConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConfigurationProperties");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "updateConfigurationProperties");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConfigurationProperties");
            if (requestBody != null) {
                handler.updateConfigurationProperties(userId, requestBody.getConnectorName(), requestBody.getMergeUpdate(), requestBody.getConfigurationProperties());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConfigurationProperties", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshAllServices(String serverName, String userId, NullRequestBody requestBody) {
        String methodName = "refreshAllServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshAllServices");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshAllServices");
            List<IntegrationServiceHandler> handlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "refreshAllServices");
            if (handlers != null) {
                for (IntegrationServiceHandler handler : handlers) {
                    if (handler == null) continue;
                    handler.refreshService(null);
                }
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshAllServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "refreshService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "refreshService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.refreshService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "restartService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restartService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "restartService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.restartService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "restartService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(String serverName, String userId) {
        String methodName = "getIntegrationDaemonStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse response = new IntegrationDaemonStatusResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationDaemonStatus");
            List<IntegrationServiceHandler> integrationServiceHandlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationDaemonStatus");
            IntegrationDaemonStatus integrationDaemonStatus = new IntegrationDaemonStatus();
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (integrationServiceHandlers != null) {
                for (IntegrationServiceHandler handler : integrationServiceHandlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getIntegrationServiceSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                integrationDaemonStatus.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
            integrationDaemonStatus.setIntegrationGroupSummaries(instanceHandler.getIntegrationGroupSummaries(userId, serverName, "getIntegrationDaemonStatus"));
            response.setIntegrationDaemonStatus(integrationDaemonStatus);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationDaemonStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServiceSummaryResponse getIntegrationServicesSummaries(String serverName, String userId) {
        String methodName = "getIntegrationServicesSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServicesSummaries");
        IntegrationServiceSummaryResponse response = new IntegrationServiceSummaryResponse();
        AuditLog auditLog = null;
        try {
            List<IntegrationServiceHandler> integrationServiceHandlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationServicesSummaries");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationServicesSummaries");
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (integrationServiceHandlers != null) {
                for (IntegrationServiceHandler handler : integrationServiceHandlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getIntegrationServiceSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                response.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationServicesSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConfig(String serverName, String userId, String integrationGroupName) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            instanceHandler.refreshConfig(userId, serverName, integrationGroupName, "refreshConfig");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupSummaryResponse getIntegrationGroupSummary(String serverName, String userId, String integrationGroupName) {
        String methodName = "getIntegrationGroupSummary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupSummary");
        IntegrationGroupSummaryResponse response = new IntegrationGroupSummaryResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupSummary");
            response.setIntegrationGroupSummary(instanceHandler.getIntegrationGroupSummary(userId, serverName, integrationGroupName, "getIntegrationGroupSummary"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupSummary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupSummariesResponse getIntegrationGroupSummaries(String serverName, String userId) {
        String methodName = "getIntegrationGroupSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupSummaries");
        IntegrationGroupSummariesResponse response = new IntegrationGroupSummariesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupSummaries");
            response.setIntegrationGroupSummaries(instanceHandler.getIntegrationGroupSummaries(userId, serverName, "getIntegrationGroupSummaries"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

