/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstance;

public class IntegrationDaemonInstanceHandler
extends GovernanceServerServiceInstanceHandler {
    public IntegrationDaemonInstanceHandler() {
        super(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName());
    }

    List<IntegrationServiceHandler> getAllIntegrationServiceHandlers(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getAllIntegrationServiceHandlers(serviceOperationName);
        }
        return null;
    }

    public IntegrationServiceHandler getIntegrationServiceHandler(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationServiceHandler(serviceURLMarker, serviceOperationName);
        }
        return null;
    }

    public IntegrationContextManager getIntegrationServiceContextManager(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationServiceHandler handler;
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null && (handler = instance.getIntegrationServiceHandler(serviceURLMarker, serviceOperationName)) != null) {
            return handler.getContextManager();
        }
        return null;
    }

    void refreshIntegrationGroupConfig(String userId, String serverName, String integrationGroupName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, methodName);
        if (instance != null) {
            instance.refreshIntegrationGroupConfig(integrationGroupName, methodName);
        }
    }

    IntegrationGroupSummary getIntegrationGroupSummary(String userId, String serverName, String integrationGroupName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationGroupSummary(integrationGroupName, serviceOperationName);
        }
        return null;
    }

    List<IntegrationGroupSummary> getIntegrationGroupSummaries(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationGroupSummaries(serviceOperationName);
        }
        return null;
    }

    public Map<String, Object> getConfigurationProperties(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getConfigurationProperties(connectorName);
        }
        return null;
    }

    public void updateConfigurationProperties(String userId, String serverName, String serviceOperationName, String connectorName, boolean isMergeUpdate, Map<String, Object> configurationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.updateConfigurationProperties(userId, connectorName, isMergeUpdate, configurationProperties);
        }
    }

    public void refreshConnector(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.refreshConnector(connectorName);
        }
    }

    public void restartConnector(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.restartConnector(connectorName);
        }
    }
}

