/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.listener;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.client.IntegrationGroupConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;

public class GovernanceEngineOutTopicListener
extends GovernanceEngineEventListener {
    private final String groupName;
    private final IntegrationGroupHandler groupHandler;
    private final IntegrationGroupConfigurationClient configurationClient;
    private final String userId;
    private final AuditLog auditLog;

    public GovernanceEngineOutTopicListener(String groupName, IntegrationGroupHandler integrationGroupHandler, IntegrationGroupConfigurationClient configurationClient, String userId, AuditLog auditLog) {
        this.groupName = groupName;
        this.groupHandler = integrationGroupHandler;
        this.configurationClient = configurationClient;
        this.userId = userId;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        String actionDescription = "Process OutTopic event";
        if (event != null && event instanceof WatchdogGovernanceServiceEvent) {
            WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event;
            WatchdogGovernanceEvent watchdogGovernanceEvent = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
            if (watchdogGovernanceEvent instanceof WatchdogClassificationEvent) {
                WatchdogClassificationEvent watchdogClassificationEvent = (WatchdogClassificationEvent)watchdogGovernanceEvent;
                elementTypeName = watchdogClassificationEvent.getMetadataElement().getType().getTypeName();
                if (((String)elementTypeName).equals("IntegrationGroup")) {
                    this.processIntegrationGroupEvent(watchdogClassificationEvent.getMetadataElement(), watchdogGovernanceServiceEvent);
                } else if (((String)elementTypeName).equals("IntegrationConnector")) {
                    this.processIntegrationConnectorEvent(watchdogClassificationEvent.getMetadataElement().getElementGUID(), watchdogGovernanceServiceEvent);
                }
            } else {
                elementTypeName = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                if (elementTypeName instanceof WatchdogMetadataElementEvent) {
                    WatchdogMetadataElementEvent watchdogMetadataElementEvent = (WatchdogMetadataElementEvent)elementTypeName;
                    if (((String)(elementTypeName = watchdogMetadataElementEvent.getMetadataElement().getType().getTypeName())).equals("IntegrationGroup")) {
                        this.processIntegrationGroupEvent(watchdogMetadataElementEvent.getMetadataElement(), watchdogGovernanceServiceEvent);
                    } else if (((String)elementTypeName).equals("IntegrationConnector")) {
                        this.processIntegrationConnectorEvent(watchdogMetadataElementEvent.getMetadataElement().getElementGUID(), watchdogGovernanceServiceEvent);
                    }
                } else {
                    WatchdogRelatedElementsEvent watchdogMetadataElementEvent;
                    elementTypeName = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                    if (elementTypeName instanceof WatchdogRelatedElementsEvent && ((String)(elementTypeName = (watchdogMetadataElementEvent = (WatchdogRelatedElementsEvent)elementTypeName).getRelatedMetadataElements().getType().getTypeName())).equals("RegisteredIntegrationConnector")) {
                        this.processIntegrationConnectorEvent(watchdogMetadataElementEvent.getRelatedMetadataElements().getElementGUIDAtEnd2(), watchdogGovernanceServiceEvent);
                    }
                }
            }
        }
    }

    private void processIntegrationGroupEvent(OpenMetadataElement integrationGroup, WatchdogGovernanceServiceEvent event) {
        String actionDescription = "processIntegrationGroupEvent";
        PropertyValue elementQualifiedName = integrationGroup.getElementProperties().getPropertyValue("qualifiedName");
        if (elementQualifiedName != null && this.groupName.equals(elementQualifiedName.valueAsString())) {
            try {
                this.groupHandler.refreshConfig();
            }
            catch (Exception error) {
                this.auditLog.logException("processIntegrationGroupEvent", IntegrationDaemonServicesAuditCode.GROUP_CHANGE_FAILED.getMessageDefinition(new String[]{this.groupName, error.getClass().getName(), error.getMessage()}), event.toString(), (Throwable)error);
            }
        }
    }

    private void processIntegrationConnectorEvent(String integrationConnectorGUID, WatchdogGovernanceServiceEvent event) {
        String actionDescription = "processIntegrationConnectorEvent";
        try {
            List registrations = this.configurationClient.getIntegrationConnectorRegistrations(this.userId, integrationConnectorGUID);
            if (registrations != null) {
                for (String groupGUID : registrations) {
                    if (groupGUID == null || !groupGUID.equals(this.groupHandler.getIntegrationGroupGUID())) continue;
                    this.groupHandler.refreshConnectorConfig(integrationConnectorGUID);
                }
            }
        }
        catch (Exception error) {
            String eventString = null;
            if (event != null) {
                eventString = event.toString();
            }
            this.auditLog.logException("processIntegrationConnectorEvent", IntegrationDaemonServicesAuditCode.CONNECTOR_CHANGE_FAILED.getMessageDefinition(new String[]{integrationConnectorGUID, error.getClass().getName(), error.getMessage()}), eventString, (Throwable)error);
        }
    }
}

