/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorBase;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContextRefreshProxy;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads.IntegrationConnectorDedicatedThread;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads.IntegrationConnectorRefreshThread;

public class IntegrationConnectorHandler {
    private final String integrationServiceFullName;
    private final String integrationDaemonName;
    private final String integrationConnectorId;
    private String integrationConnectorGUID;
    private String integrationConnectorName;
    private String integrationConnectorUserId;
    private Date startDate;
    private Date stopDate;
    private String metadataSourceQualifiedName;
    private PermittedSynchronization permittedSynchronization;
    private final boolean generateIntegrationReport;
    private Connection connection;
    private boolean needDedicatedThread;
    private long minMinutesBetweenRefresh;
    private final IntegrationContextManager contextManager;
    private final AuditLog auditLog;
    private IntegrationContext integrationContext = null;
    private IntegrationContextRefreshProxy integrationContextRefreshProxy = null;
    private Connector genericConnector = null;
    private IntegrationConnector integrationConnector = null;
    private IntegrationConnectorDedicatedThread integrationConnectorDedicatedThread = null;
    private IntegrationConnectorRefreshThread integrationConnectorRefreshThread = null;
    private IntegrationConnectorStatus integrationConnectorStatus = null;
    private Date lastStatusChange = null;
    private String failingExceptionMessage = null;
    private Date lastRefreshTime = null;

    IntegrationConnectorHandler(String connectorId, String connectorGUID, String connectorName, String connectorUserId, Date startDate, Date stopDate, long minMinutesBetweenRefresh, String metadataSourceQualifiedName, Connection connection, boolean usesBlockingCalls, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String integrationServiceFullName, String integrationDaemonName, IntegrationContextManager contextManager, AuditLog auditLog) {
        String actionDescription = "Initializing integration connector";
        this.integrationServiceFullName = integrationServiceFullName;
        this.integrationDaemonName = integrationDaemonName;
        this.integrationConnectorId = connectorId;
        this.integrationConnectorGUID = connectorGUID;
        this.integrationConnectorName = connectorName;
        this.integrationConnectorUserId = connectorUserId;
        this.startDate = startDate;
        this.stopDate = stopDate;
        this.metadataSourceQualifiedName = metadataSourceQualifiedName;
        this.minMinutesBetweenRefresh = minMinutesBetweenRefresh;
        this.connection = connection;
        this.needDedicatedThread = usesBlockingCalls;
        this.permittedSynchronization = permittedSynchronization;
        this.generateIntegrationReport = generateIntegrationReport;
        this.contextManager = contextManager;
        this.auditLog = auditLog;
        this.reinitializeConnector("Initializing integration connector");
    }

    public String getIntegrationConnectorId() {
        return this.integrationConnectorId;
    }

    public String getIntegrationConnectorName() {
        return this.integrationConnectorName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getIntegrationConnectorInstanceId() {
        if (this.genericConnector != null) {
            return this.genericConnector.getConnectorInstanceId();
        }
        return null;
    }

    public boolean needsDedicatedThread() {
        return this.needDedicatedThread;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getStopDate() {
        return this.stopDate;
    }

    public IntegrationConnectorStatus getIntegrationConnectorStatus() {
        return this.integrationConnectorStatus;
    }

    public Date getLastStatusChange() {
        return this.lastStatusChange;
    }

    public String getFailingExceptionMessage() {
        return this.failingExceptionMessage;
    }

    public Map<String, Object> getStatistics() {
        if (this.genericConnector != null) {
            return this.genericConnector.getConnectorStatistics();
        }
        return null;
    }

    public Date getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    public long getMinMinutesBetweenRefresh() {
        return this.minMinutesBetweenRefresh;
    }

    private Connector getConnector(Connection connection, String actionDescription) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
        try {
            return connectorBroker.getConnector(connection);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException error) {
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.BAD_INTEGRATION_CONNECTION.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationServiceFullName, error.getClass().getName(), error.getMessage()}));
            throw error;
        }
    }

    public synchronized void reinitializeConnector(String actionDescription) {
        String operationName = "initialize";
        this.disconnectConnector(actionDescription);
        this.resetConnectorHandler();
        this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.INTEGRATION_CONNECTOR_INITIALIZING.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationServiceFullName, this.integrationDaemonName, this.permittedSynchronization.getName()}));
        this.genericConnector = null;
        this.integrationConnector = null;
        try {
            this.genericConnector = this.getConnector(this.connection, actionDescription);
            this.integrationConnector = (IntegrationConnector)this.genericConnector;
        }
        catch (ClassCastException error) {
            String connectorClassName = null;
            if (this.genericConnector != null) {
                connectorClassName = this.genericConnector.getClass().getName();
            }
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.NOT_INTEGRATION_CONNECTOR.getMessageDefinition(new String[]{this.integrationConnectorName, connectorClassName, IntegrationConnector.class.getCanonicalName()}));
            this.processConfigException(actionDescription, "initialize", error);
        }
        catch (Exception error) {
            this.processConfigException(actionDescription, "initialize", error);
        }
        try {
            this.integrationContext = this.contextManager.setContext(this.integrationConnectorId, this.integrationConnectorName, this.integrationConnectorUserId, this.integrationConnector, this.integrationConnectorGUID, this.permittedSynchronization, this.generateIntegrationReport, this.metadataSourceQualifiedName);
            this.integrationContextRefreshProxy = new IntegrationContextRefreshProxy(this.integrationContext);
            this.updateStatus(IntegrationConnectorStatus.INITIALIZED);
        }
        catch (Exception error) {
            this.processInitializeException(actionDescription, error);
        }
        try {
            if (this.needDedicatedThread) {
                if (this.integrationConnectorDedicatedThread != null) {
                    this.integrationConnectorDedicatedThread.stop();
                }
                this.integrationConnectorDedicatedThread = new IntegrationConnectorDedicatedThread(this.integrationDaemonName, this, this.auditLog);
                this.integrationConnectorDedicatedThread.start();
            } else {
                if (this.integrationConnectorRefreshThread != null) {
                    this.integrationConnectorRefreshThread.stop();
                }
                this.integrationConnectorRefreshThread = new IntegrationConnectorRefreshThread(this.integrationDaemonName, this, this.auditLog);
                this.integrationConnectorRefreshThread.start();
            }
        }
        catch (Exception error) {
            this.processConfigException(actionDescription, "initialize", error);
        }
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.connection != null) {
            return this.connection.getConfigurationProperties();
        }
        return null;
    }

    public synchronized void updateConfigurationProperties(String userId, String actionDescription, boolean isMergeUpdate, Map<String, Object> configurationProperties) {
        if (this.connection != null) {
            Map<String, Object> connectionConfigurationProperties = this.connection.getConfigurationProperties();
            if (connectionConfigurationProperties != null) {
                if (isMergeUpdate) {
                    if (configurationProperties != null) {
                        connectionConfigurationProperties.putAll(configurationProperties);
                    }
                } else {
                    connectionConfigurationProperties = configurationProperties;
                }
            } else {
                connectionConfigurationProperties = configurationProperties;
            }
            this.connection.setConfigurationProperties(connectionConfigurationProperties);
            if (connectionConfigurationProperties != null) {
                String propertyNames = "<null>";
                if (configurationProperties != null && !configurationProperties.isEmpty()) {
                    propertyNames = configurationProperties.keySet().toString();
                }
                this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_CONFIG_PROPS_UPDATE.getMessageDefinition(new String[]{userId, this.integrationConnectorName, this.integrationDaemonName, propertyNames}));
            } else {
                this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_CONFIG_PROPS_CLEARED.getMessageDefinition(new String[]{userId, this.integrationConnectorName, this.integrationDaemonName}));
            }
            this.reinitializeConnector(actionDescription);
        }
    }

    public void updateEndpointNetworkAddress(String userId, String actionDescription, String networkAddress) {
        if (this.connection != null) {
            Endpoint endpoint = this.connection.getEndpoint();
            if (endpoint != null) {
                endpoint.setAddress(networkAddress);
                this.connection.setEndpoint(endpoint);
                this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_ENDPOINT_UPDATE.getMessageDefinition(new String[]{userId, this.integrationConnectorName, this.integrationDaemonName, networkAddress}));
            } else {
                this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_NO_ENDPOINT_TO_UPDATE.getMessageDefinition(new String[]{userId, this.integrationConnectorName, this.integrationDaemonName}));
            }
            this.reinitializeConnector(actionDescription);
        }
    }

    public void updateConnectorConnection(String userId, String actionDescription, Connection connection) {
        this.connection = connection;
        this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_ENDPOINT_UPDATE.getMessageDefinition(new String[]{userId, this.integrationConnectorName, this.integrationDaemonName}));
        this.reinitializeConnector(actionDescription);
    }

    public synchronized void engageConnector(String actionDescription) {
        String operationName = "engage";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZE_FAILED) {
                this.reinitializeConnector(actionDescription);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                this.startConnector(actionDescription, IntegrationConnectorStatus.RUNNING);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.RUNNING) {
                this.integrationConnector.engage();
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "engage", error);
        }
    }

    public synchronized void refreshConnector(String actionDescription, boolean firstCall) {
        String operationName = "refresh";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZE_FAILED) {
                this.reinitializeConnector(actionDescription);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                this.startConnector(actionDescription, IntegrationConnectorStatus.WAITING);
            }
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.WAITING) {
                this.updateStatus(IntegrationConnectorStatus.REFRESHING);
                Date refreshStart = new Date();
                if (this.auditLog != null) {
                    if (firstCall) {
                        this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_FIRST_REFRESH.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationDaemonName}));
                    } else {
                        this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_REFRESH.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationDaemonName}));
                    }
                }
                this.integrationContext.startRecording();
                this.integrationContextRefreshProxy.setRefreshInProgress(true);
                this.integrationConnector.refresh();
                this.integrationContextRefreshProxy.setRefreshInProgress(false);
                this.integrationContext.publishReport();
                this.updateStatus(IntegrationConnectorStatus.WAITING);
                if (this.auditLog != null) {
                    Date refreshEnd = new Date();
                    this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.DAEMON_CONNECTOR_REFRESH_COMPLETE.getMessageDefinition(new String[]{this.integrationConnectorName, this.integrationDaemonName, Long.toString(refreshEnd.getTime() - refreshStart.getTime())}));
                }
            }
            this.lastRefreshTime = new Date();
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "refresh", error);
        }
    }

    public synchronized void updateConnectorDetails(RegisteredIntegrationConnectorElement registeredIntegrationConnectorElement) {
        String methodName = "updateConnectorDetails";
        this.integrationConnectorGUID = registeredIntegrationConnectorElement.getElementHeader().getGUID();
        this.integrationConnectorName = registeredIntegrationConnectorElement.getRegistrationProperties().getConnectorName();
        this.integrationConnectorUserId = registeredIntegrationConnectorElement.getRegistrationProperties().getConnectorUserId();
        this.startDate = registeredIntegrationConnectorElement.getRegistrationProperties().getStartDate();
        this.stopDate = registeredIntegrationConnectorElement.getRegistrationProperties().getStopDate();
        this.metadataSourceQualifiedName = registeredIntegrationConnectorElement.getRegistrationProperties().getMetadataSourceQualifiedName();
        this.permittedSynchronization = registeredIntegrationConnectorElement.getRegistrationProperties().getPermittedSynchronization();
        this.minMinutesBetweenRefresh = registeredIntegrationConnectorElement.getRegistrationProperties().getRefreshTimeInterval();
        if (!this.connection.equals((Object)registeredIntegrationConnectorElement.getProperties().getConnection()) && registeredIntegrationConnectorElement.getProperties().getConnection() != null) {
            this.connection = registeredIntegrationConnectorElement.getProperties().getConnection();
            this.reinitializeConnector("updateConnectorDetails");
        }
        if (this.needDedicatedThread != registeredIntegrationConnectorElement.getProperties().getUsesBlockingCalls()) {
            this.needDedicatedThread = registeredIntegrationConnectorElement.getProperties().getUsesBlockingCalls();
            this.reinitializeConnector("updateConnectorDetails");
        }
    }

    public synchronized void shutdown(String actionDescription) {
        this.disconnectConnector(actionDescription);
        this.resetConnectorHandler();
    }

    private void startConnector(String actionDescription, IntegrationConnectorStatus nextStatus) {
        String operationName = "start";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.INITIALIZED) {
                if (this.integrationConnector instanceof IntegrationConnectorBase) {
                    this.integrationConnector.setConnectorName(this.integrationConnectorName);
                }
                this.integrationConnector.start();
                this.updateStatus(nextStatus);
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "start", error);
        }
    }

    public void disconnectConnector(String actionDescription) {
        String operationName = "disconnect";
        try {
            if (this.integrationConnectorStatus == IntegrationConnectorStatus.RUNNING || this.integrationConnectorStatus == IntegrationConnectorStatus.FAILED) {
                if (this.integrationContext != null) {
                    this.integrationContext.disconnect();
                }
                this.integrationConnector.disconnect();
                this.updateStatus(IntegrationConnectorStatus.STOPPED);
            }
        }
        catch (Exception error) {
            this.processConnectorException(actionDescription, "disconnect", error);
        }
    }

    private void resetConnectorHandler() {
        if (this.integrationConnectorDedicatedThread != null) {
            this.integrationConnectorDedicatedThread.stop();
        }
        if (this.integrationConnectorRefreshThread != null) {
            this.integrationConnectorRefreshThread.stop();
        }
        this.updateStatus(null);
        this.genericConnector = null;
        this.integrationConnector = null;
        this.integrationConnectorDedicatedThread = null;
        this.failingExceptionMessage = null;
        this.lastRefreshTime = null;
    }

    private void processConfigException(String actionDescription, String operationName, Exception error) {
        this.updateStatus(IntegrationConnectorStatus.CONFIG_FAILED);
        this.failingExceptionMessage = error.getMessage();
        if (error instanceof OCFCheckedExceptionBase) {
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.CONFIG_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, operationName, error.getClass().getName(), error.getMessage()}));
        } else {
            this.auditLog.logException(actionDescription, IntegrationDaemonServicesAuditCode.CONFIG_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, operationName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
    }

    private void processConnectorException(String actionDescription, String operationName, Exception error) {
        this.updateStatus(IntegrationConnectorStatus.FAILED);
        this.failingExceptionMessage = error.getMessage();
        if (error instanceof OCFCheckedExceptionBase) {
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.CONNECTOR_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, operationName, error.getClass().getName(), error.getMessage()}));
        } else {
            this.auditLog.logException(actionDescription, IntegrationDaemonServicesAuditCode.CONNECTOR_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, operationName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
    }

    private void processInitializeException(String actionDescription, Exception error) {
        String operationName = "setContext";
        this.updateStatus(IntegrationConnectorStatus.INITIALIZE_FAILED);
        this.failingExceptionMessage = error.getMessage();
        if (error instanceof OCFCheckedExceptionBase) {
            this.auditLog.logMessage(actionDescription, IntegrationDaemonServicesAuditCode.INITIALIZE_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, "setContext", error.getClass().getName(), error.getMessage()}));
        } else {
            this.auditLog.logException(actionDescription, IntegrationDaemonServicesAuditCode.INITIALIZE_ERROR.getMessageDefinition(new String[]{this.integrationConnectorName, "setContext", error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
    }

    private void updateStatus(IntegrationConnectorStatus newStatus) {
        if (newStatus == null) {
            this.integrationConnectorStatus = null;
            this.lastStatusChange = null;
        } else {
            this.integrationConnectorStatus = newStatus;
            this.lastStatusChange = new Date();
        }
    }
}

