/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.listener;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceserver.api.GovernanceServerEventListener;
import org.odpi.openmetadata.accessservices.governanceserver.client.IntegrationGroupConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServerEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.IntegrationConnectorConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.IntegrationGroupConfigurationEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;

public class GovernanceServerOutTopicListener
extends GovernanceServerEventListener {
    private final String groupName;
    private final IntegrationGroupHandler groupHandler;
    private final IntegrationGroupConfigurationClient configurationClient;
    private final String userId;
    private final AuditLog auditLog;

    public GovernanceServerOutTopicListener(String groupName, IntegrationGroupHandler integrationGroupHandler, IntegrationGroupConfigurationClient configurationClient, String userId, AuditLog auditLog) {
        this.groupName = groupName;
        this.groupHandler = integrationGroupHandler;
        this.configurationClient = configurationClient;
        this.userId = userId;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceServerEvent event) {
        if (event != null) {
            if (event instanceof IntegrationGroupConfigurationEvent) {
                IntegrationGroupConfigurationEvent integrationGroupConfigurationEvent = (IntegrationGroupConfigurationEvent)event;
                this.processIntegrationGroupEvent(integrationGroupConfigurationEvent);
            } else if (event instanceof IntegrationConnectorConfigurationEvent) {
                IntegrationConnectorConfigurationEvent integrationConnectorConfigurationEvent = (IntegrationConnectorConfigurationEvent)event;
                this.processIntegrationConnectorEvent(integrationConnectorConfigurationEvent);
            }
        }
    }

    private void processIntegrationGroupEvent(IntegrationGroupConfigurationEvent event) {
        String actionDescription = "processIntegrationGroupEvent";
        if (event.getIntegrationGroupName() != null && this.groupName.equals(event.getIntegrationGroupName())) {
            try {
                this.groupHandler.refreshConfig();
            }
            catch (Exception error) {
                this.auditLog.logException("processIntegrationGroupEvent", IntegrationDaemonServicesAuditCode.GROUP_CHANGE_FAILED.getMessageDefinition(new String[]{this.groupName, error.getClass().getName(), error.getMessage()}), event.toString(), (Throwable)error);
            }
        }
    }

    private void processIntegrationConnectorEvent(IntegrationConnectorConfigurationEvent event) {
        String actionDescription = "processIntegrationConnectorEvent";
        try {
            List registrations = this.configurationClient.getIntegrationConnectorRegistrations(this.userId, event.getIntegrationConnectorGUID());
            if (registrations != null) {
                for (String groupGUID : registrations) {
                    if (groupGUID == null || !groupGUID.equals(this.groupHandler.getIntegrationGroupGUID())) continue;
                    this.groupHandler.refreshConnectorConfig(event.getIntegrationConnectorGUID());
                }
            }
        }
        catch (Exception error) {
            String eventString = null;
            String integrationConnectorId = null;
            if (event != null) {
                eventString = event.toString();
                if (event.getIntegrationConnectorName() != null) {
                    integrationConnectorId = event.getIntegrationConnectorName();
                } else if (event.getIntegrationConnectorGUID() != null) {
                    integrationConnectorId = event.getIntegrationConnectorGUID();
                }
            }
            this.auditLog.logException("processIntegrationConnectorEvent", IntegrationDaemonServicesAuditCode.CONNECTOR_CHANGE_FAILED.getMessageDefinition(new String[]{integrationConnectorId, error.getClass().getName(), error.getMessage()}), eventString, (Throwable)error);
        }
    }
}

