/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationDaemonStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummariesResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationServiceSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.slf4j.LoggerFactory;

public class IntegrationDaemonRESTServices {
    private static final IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationDaemonRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public PropertiesResponse getConfigurationProperties(String serverName, String userId, String connectorName) {
        String methodName = "getConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfigurationProperties");
        PropertiesResponse response = new PropertiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfigurationProperties");
            response.setProperties(instanceHandler.getConfigurationProperties(userId, serverName, "getConfigurationProperties", connectorName));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConfigurationProperties(String serverName, String userId, ConnectorConfigPropertiesRequestBody requestBody) {
        String methodName = "updateConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConfigurationProperties");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConfigurationProperties");
            if (requestBody != null) {
                instanceHandler.updateConfigurationProperties(userId, serverName, "updateConfigurationProperties", requestBody.getConnectorName(), requestBody.getMergeUpdate(), requestBody.getConfigurationProperties());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConfigurationProperties", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpointNetworkAddress(String serverName, String userId, String connectorName, StringRequestBody requestBody) {
        String methodName = "updateEndpointNetworkAddress";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpointNetworkAddress");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpointNetworkAddress");
            if (requestBody != null) {
                instanceHandler.updateEndpointNetworkAddress(userId, serverName, "updateEndpointNetworkAddress", connectorName, requestBody.getString());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateEndpointNetworkAddress", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpointNetworkAddress", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnectorConnection(String serverName, String userId, String connectorName, Connection requestBody) {
        String methodName = "updateConnectorConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnectorConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnectorConnection");
            if (requestBody != null) {
                instanceHandler.updateConnectorConnection(userId, serverName, "updateConnectorConnection", connectorName, requestBody);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateConnectorConnection", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnectorConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConnectors(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "refreshConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConnectors");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConnectors");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            instanceHandler.refreshConnector(userId, serverName, "refreshConnectors", connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartConnectors(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "restartConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restartConnectors");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartConnectors");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            instanceHandler.restartConnector(userId, serverName, "restartConnectors", connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "restartConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "refreshService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "refreshService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.refreshService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartService(String serverName, String userId, String serviceURLMarker, NameRequestBody requestBody) {
        String methodName = "restartService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restartService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationServiceHandler handler = instanceHandler.getIntegrationServiceHandler(userId, serverName, serviceURLMarker, "restartService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartService");
            String connectorName = null;
            if (requestBody != null) {
                connectorName = requestBody.getName();
            }
            handler.restartService(connectorName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "restartService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(String serverName, String userId) {
        String methodName = "getIntegrationDaemonStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationDaemonStatus");
        IntegrationDaemonStatusResponse response = new IntegrationDaemonStatusResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationDaemonStatus");
            List<IntegrationServiceHandler> integrationServiceHandlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationDaemonStatus");
            IntegrationDaemonStatus integrationDaemonStatus = new IntegrationDaemonStatus();
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (integrationServiceHandlers != null) {
                for (IntegrationServiceHandler handler : integrationServiceHandlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getIntegrationServiceSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                integrationDaemonStatus.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
            integrationDaemonStatus.setIntegrationGroupSummaries(instanceHandler.getIntegrationGroupSummaries(userId, serverName, "getIntegrationDaemonStatus"));
            integrationDaemonStatus.setIntegrationConnectorReports(instanceHandler.getIntegrationConnectors(userId, serverName, "getIntegrationDaemonStatus"));
            response.setIntegrationDaemonStatus(integrationDaemonStatus);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationDaemonStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationServiceSummaryResponse getIntegrationServicesSummaries(String serverName, String userId) {
        String methodName = "getIntegrationServicesSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationServicesSummaries");
        IntegrationServiceSummaryResponse response = new IntegrationServiceSummaryResponse();
        AuditLog auditLog = null;
        try {
            List<IntegrationServiceHandler> integrationServiceHandlers = instanceHandler.getAllIntegrationServiceHandlers(userId, serverName, "getIntegrationServicesSummaries");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationServicesSummaries");
            ArrayList<IntegrationServiceSummary> integrationServiceSummaries = new ArrayList<IntegrationServiceSummary>();
            if (integrationServiceHandlers != null) {
                for (IntegrationServiceHandler handler : integrationServiceHandlers) {
                    if (handler == null) continue;
                    integrationServiceSummaries.add(handler.getIntegrationServiceSummary());
                }
            }
            if (!integrationServiceSummaries.isEmpty()) {
                response.setIntegrationServiceSummaries(integrationServiceSummaries);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationServicesSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshIntegrationGroupConfig(String serverName, String userId, String integrationGroupName) {
        String methodName = "refreshIntegrationGroupConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshIntegrationGroupConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshIntegrationGroupConfig");
            instanceHandler.refreshIntegrationGroupConfig(userId, serverName, integrationGroupName, "refreshIntegrationGroupConfig");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshIntegrationGroupConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupSummaryResponse getIntegrationGroupSummary(String serverName, String userId, String integrationGroupName) {
        String methodName = "getIntegrationGroupSummary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupSummary");
        IntegrationGroupSummaryResponse response = new IntegrationGroupSummaryResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupSummary");
            response.setIntegrationGroupSummary(instanceHandler.getIntegrationGroupSummary(userId, serverName, integrationGroupName, "getIntegrationGroupSummary"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupSummary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupSummariesResponse getIntegrationGroupSummaries(String serverName, String userId) {
        String methodName = "getIntegrationGroupSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupSummaries");
        IntegrationGroupSummariesResponse response = new IntegrationGroupSummariesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupSummaries");
            response.setIntegrationGroupSummaries(instanceHandler.getIntegrationGroupSummaries(userId, serverName, "getIntegrationGroupSummaries"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

