/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads;

import org.odpi.openmetadata.accessservices.governanceserver.api.GovernanceServerEventListener;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceServerEventClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.listener.GovernanceServerOutTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupConfigurationRefreshThread
implements Runnable {
    private final String groupName;
    private final IntegrationGroupHandler groupHandler;
    private final GovernanceServerEventClient eventClient;
    private final AuditLog auditLog;
    private final String localServerUserId;
    private final String localServerName;
    private final String accessServiceServerName;
    private final String accessServiceRootURL;
    private final int maxPageSize;
    private volatile boolean keepTrying = true;
    private static final Logger log = LoggerFactory.getLogger(GroupConfigurationRefreshThread.class);

    public GroupConfigurationRefreshThread(String groupName, IntegrationGroupHandler groupHandler, GovernanceServerEventClient eventClient, AuditLog auditLog, String localServerUserId, String localServerName, String accessServiceServerName, String accessServiceRootURL, int maxPageSize) {
        this.groupName = groupName;
        this.groupHandler = groupHandler;
        this.eventClient = eventClient;
        this.auditLog = auditLog;
        this.localServerUserId = localServerUserId;
        this.localServerName = localServerName;
        this.accessServiceServerName = accessServiceServerName;
        this.accessServiceRootURL = accessServiceRootURL;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void run() {
        String actionDescription = "Register configuration listener";
        boolean listenerRegistered = false;
        while (this.keepTrying) {
            while (!listenerRegistered && this.keepTrying) {
                try {
                    GovernanceConfigurationClient configurationClient = new GovernanceConfigurationClient(this.accessServiceServerName, this.accessServiceRootURL, this.maxPageSize);
                    this.eventClient.registerListener(this.localServerUserId, (GovernanceServerEventListener)new GovernanceServerOutTopicListener(this.groupName, this.groupHandler, configurationClient, this.localServerUserId, this.auditLog));
                    listenerRegistered = true;
                    this.auditLog.logMessage("Register configuration listener", IntegrationDaemonServicesAuditCode.CONFIGURATION_LISTENER_REGISTERED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName}));
                }
                catch (UserNotAuthorizedException error) {
                    this.auditLog.logException("Register configuration listener", IntegrationDaemonServicesAuditCode.SERVER_NOT_AUTHORIZED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, this.accessServiceRootURL, this.localServerUserId, error.getReportedErrorMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
                catch (Exception error) {
                    this.auditLog.logException("Register configuration listener", IntegrationDaemonServicesAuditCode.NO_CONFIGURATION_LISTENER.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
            }
            while (this.keepTrying) {
                try {
                    this.groupHandler.refreshConfig();
                }
                catch (Exception error) {
                    this.auditLog.logException("Register configuration listener", IntegrationDaemonServicesAuditCode.INTEGRATION_GROUP_NO_CONFIG.getMessageDefinition(new String[]{this.groupHandler.getIntegrationGroupName(), error.getClass().getName(), error.getMessage()}), error.toString(), (Throwable)error);
                }
                this.waitToRetry();
            }
            this.waitToRetry();
        }
    }

    private void waitToRetry() {
        int sleepTime = 2000000;
        if (this.keepTrying) {
            try {
                Thread.sleep(2000000L);
            }
            catch (Exception error) {
                log.error("Ignored exception from sleep - probably ok", (Throwable)error);
            }
        }
    }

    public void stop() {
        this.keepTrying = false;
    }
}

