/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstance;

public class IntegrationDaemonInstanceHandler
extends GovernanceServerServiceInstanceHandler {
    public IntegrationDaemonInstanceHandler() {
        super(GovernanceServicesDescription.INTEGRATION_DAEMON_SERVICES.getServiceName());
    }

    List<IntegrationServiceHandler> getAllIntegrationServiceHandlers(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getAllIntegrationServiceHandlers(serviceOperationName);
        }
        return null;
    }

    public IntegrationServiceHandler getIntegrationServiceHandler(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationServiceHandler(serviceURLMarker, serviceOperationName);
        }
        return null;
    }

    public List<IntegrationContextManager> getIntegrationServiceContextManagers(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            List<IntegrationGroupHandler> groupHandlers;
            ArrayList<IntegrationContextManager> contextManagers = new ArrayList<IntegrationContextManager>();
            IntegrationServiceHandler serviceHandler = null;
            InvalidParameterException invalidParameterException = null;
            try {
                serviceHandler = instance.getIntegrationServiceHandler(serviceURLMarker, serviceOperationName);
            }
            catch (InvalidParameterException notKnownException) {
                invalidParameterException = notKnownException;
            }
            if (serviceHandler != null) {
                contextManagers.add(serviceHandler.getContextManager());
            }
            if ((groupHandlers = instance.getAllIntegrationGroupHandlers(serviceOperationName)) != null) {
                for (IntegrationGroupHandler groupHandler : groupHandlers) {
                    IntegrationContextManager contextManager;
                    if (groupHandler == null || (contextManager = groupHandler.getContextManager(serviceURLMarker)) == null) continue;
                    contextManagers.add(contextManager);
                }
            }
            if (!contextManagers.isEmpty()) {
                return contextManagers;
            }
            if (invalidParameterException != null) {
                throw invalidParameterException;
            }
        }
        return null;
    }

    void refreshIntegrationGroupConfig(String userId, String serverName, String integrationGroupName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, methodName);
        if (instance != null) {
            instance.refreshIntegrationGroupConfig(integrationGroupName, methodName);
        }
    }

    IntegrationGroupSummary getIntegrationGroupSummary(String userId, String serverName, String integrationGroupName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationGroupSummary(integrationGroupName, serviceOperationName);
        }
        return null;
    }

    List<IntegrationGroupSummary> getIntegrationGroupSummaries(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getIntegrationGroupSummaries(serviceOperationName);
        }
        return null;
    }

    List<IntegrationConnectorReport> getIntegrationConnectors(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getConnectorReports();
        }
        return null;
    }

    public Map<String, Object> getConfigurationProperties(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getConfigurationProperties(connectorName);
        }
        return null;
    }

    public void updateConfigurationProperties(String userId, String serverName, String serviceOperationName, String connectorName, boolean isMergeUpdate, Map<String, Object> configurationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.updateConfigurationProperties(userId, connectorName, isMergeUpdate, configurationProperties);
        }
    }

    public void updateEndpointNetworkAddress(String userId, String serverName, String serviceOperationName, String connectorName, String networkAddress) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.updateEndpointNetworkAddress(userId, connectorName, networkAddress);
        }
    }

    public void updateConnectorConnection(String userId, String serverName, String serviceOperationName, String connectorName, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.updateConnectorConnection(userId, connectorName, connection);
        }
    }

    public void refreshConnector(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.refreshConnector(connectorName);
        }
    }

    public void restartConnector(String userId, String serverName, String serviceOperationName, String connectorName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationDaemonInstance instance = (IntegrationDaemonInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.restartConnector(connectorName);
        }
    }
}

