/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;

public class IntegrationServiceHandler {
    private final String localServerName;
    private final String localServerUserId;
    private final IntegrationServiceConfig serviceConfig;
    private final IntegrationContextManager contextManager;
    private final AuditLog auditLog;
    private final List<IntegrationConnectorHandler> connectorHandlers = new ArrayList<IntegrationConnectorHandler>();

    public IntegrationServiceHandler(String localServerName, String localServerUserId, IntegrationServiceConfig serviceConfig, IntegrationContextManager contextManager, AuditLog auditLog) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.serviceConfig = serviceConfig;
        this.contextManager = contextManager;
        this.auditLog = auditLog;
    }

    public IntegrationContextManager getContextManager() {
        return this.contextManager;
    }

    public String getIntegrationServiceFullName() {
        return this.serviceConfig.getIntegrationServiceFullName();
    }

    public List<IntegrationConnectorHandler> initialize() {
        List connectorConfigurationList = this.serviceConfig.getIntegrationConnectorConfigs();
        if (connectorConfigurationList != null) {
            for (IntegrationConnectorConfig connectorConfig : connectorConfigurationList) {
                if (connectorConfig == null) continue;
                if (connectorConfig.getPermittedSynchronization() == null) {
                    connectorConfig.setPermittedSynchronization(this.serviceConfig.getDefaultPermittedSynchronization());
                }
                String userId = this.localServerUserId;
                if (connectorConfig.getConnectorUserId() != null) {
                    userId = connectorConfig.getConnectorUserId();
                }
                IntegrationConnectorHandler connectorHandler = new IntegrationConnectorHandler(connectorConfig.getConnectorId(), null, connectorConfig.getConnectorName(), userId, null, null, connectorConfig.getRefreshTimeInterval(), connectorConfig.getMetadataSourceQualifiedName(), connectorConfig.getConnection(), connectorConfig.getUsesBlockingCalls(), connectorConfig.getPermittedSynchronization(), connectorConfig.getGenerateIntegrationReports(), this.serviceConfig.getIntegrationServiceFullName(), this.localServerName, this.contextManager, this.auditLog);
                this.connectorHandlers.add(connectorHandler);
            }
        }
        if (this.connectorHandlers.isEmpty()) {
            String actionDescription = "Initialize integration service";
            this.auditLog.logMessage("Initialize integration service", IntegrationDaemonServicesAuditCode.NO_INTEGRATION_CONNECTORS.getMessageDefinition(new String[]{this.serviceConfig.getIntegrationServiceFullName()}));
        }
        return this.connectorHandlers;
    }

    public IntegrationServiceSummary getIntegrationServiceSummary() {
        IntegrationServiceSummary summary = new IntegrationServiceSummary();
        summary.setIntegrationServiceId(this.serviceConfig.getIntegrationServiceId());
        summary.setIntegrationServiceFullName(this.serviceConfig.getIntegrationServiceFullName());
        summary.setIntegrationServiceURLMarker(this.serviceConfig.getIntegrationServiceURLMarker());
        summary.setIntegrationServiceDescription(this.serviceConfig.getIntegrationServiceDescription());
        summary.setIntegrationServiceWiki(this.serviceConfig.getIntegrationServiceWiki());
        ArrayList<IntegrationConnectorReport> connectorReports = new ArrayList<IntegrationConnectorReport>();
        if (!this.connectorHandlers.isEmpty()) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                IntegrationConnectorReport connectorReport = new IntegrationConnectorReport();
                connectorReport.setConnectorId(connectorHandler.getIntegrationConnectorId());
                connectorReport.setConnectorName(connectorHandler.getIntegrationConnectorName());
                connectorReport.setConnectorStatus(connectorHandler.getIntegrationConnectorStatus());
                connectorReport.setConnection(connectorHandler.getConnection());
                connectorReport.setConnectorInstanceId(connectorHandler.getIntegrationConnectorInstanceId());
                connectorReport.setFailingExceptionMessage(connectorHandler.getFailingExceptionMessage());
                connectorReport.setStatistics(connectorHandler.getStatistics());
                connectorReport.setLastStatusChange(connectorHandler.getLastStatusChange());
                connectorReport.setLastRefreshTime(connectorHandler.getLastRefreshTime());
                connectorReport.setMinMinutesBetweenRefresh(connectorHandler.getMinMinutesBetweenRefresh());
                connectorReports.add(connectorReport);
            }
        }
        if (!connectorReports.isEmpty()) {
            summary.setIntegrationConnectorReports(connectorReports);
        }
        return summary;
    }

    public void refreshService(String connectorName) throws InvalidParameterException {
        String actionDescription = "Refresh service REST API call";
        if (connectorName == null) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                connectorHandler.refreshConnector("Refresh service REST API call");
            }
        } else {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null || !connectorName.equals(connectorHandler.getIntegrationConnectorName())) continue;
                connectorHandler.refreshConnector("Refresh service REST API call");
                return;
            }
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serviceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "Refresh service REST API call", "connectorName");
        }
    }

    public void restartService(String connectorName) throws InvalidParameterException {
        String actionDescription = "Restart service REST API call";
        if (connectorName == null) {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null) continue;
                connectorHandler.reinitializeConnector("Restart service REST API call");
            }
        } else {
            for (IntegrationConnectorHandler connectorHandler : this.connectorHandlers) {
                if (connectorHandler == null || !connectorName.equals(connectorHandler.getIntegrationConnectorName())) continue;
                connectorHandler.reinitializeConnector("Restart service REST API call");
                return;
            }
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serviceConfig.getIntegrationServiceFullName(), this.localServerName}), this.getClass().getName(), "Restart service REST API call", "connectorName");
        }
    }
}

