/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorCacheMap;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationGroupHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationServiceHandler;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;

public class IntegrationDaemonInstance
extends GovernanceServerServiceInstance {
    private final Map<String, IntegrationServiceHandler> integrationServiceHandlers;
    private final Map<String, IntegrationGroupHandler> integrationGroupHandlers;
    private final IntegrationConnectorCacheMap integrationConnectorCacheMap;

    IntegrationDaemonInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, Map<String, IntegrationServiceHandler> integrationServiceHandlers, Map<String, IntegrationGroupHandler> integrationGroupHandlers, IntegrationConnectorCacheMap integrationConnectorCacheMap) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize);
        this.integrationServiceHandlers = integrationServiceHandlers;
        this.integrationGroupHandlers = integrationGroupHandlers;
        this.integrationConnectorCacheMap = integrationConnectorCacheMap;
    }

    synchronized List<IntegrationServiceHandler> getAllIntegrationServiceHandlers(String serviceOperationName) throws PropertyServerException {
        if (this.integrationServiceHandlers == null || this.integrationServiceHandlers.isEmpty()) {
            return null;
        }
        return new ArrayList<IntegrationServiceHandler>(this.integrationServiceHandlers.values());
    }

    synchronized IntegrationServiceHandler getIntegrationServiceHandler(String serviceURLMarker, String serviceOperationName) throws InvalidParameterException {
        String nameParameterName = "serviceURLMarker";
        IntegrationServiceHandler handler = this.integrationServiceHandlers.get(serviceURLMarker);
        if (handler == null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_INTEGRATION_SERVICE.getMessageDefinition(new String[]{serviceURLMarker, this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "serviceURLMarker");
        }
        return handler;
    }

    synchronized List<IntegrationGroupHandler> getAllIntegrationGroupHandlers(String serviceOperationName) throws PropertyServerException {
        if (this.integrationGroupHandlers == null || this.integrationGroupHandlers.isEmpty()) {
            return null;
        }
        return new ArrayList<IntegrationGroupHandler>(this.integrationGroupHandlers.values());
    }

    void refreshIntegrationGroupConfig(String integrationGroupName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String integrationGroupParameterName = "integrationGroupName";
        this.invalidParameterHandler.validateName(integrationGroupName, "integrationGroupName", serviceOperationName);
        if (this.integrationGroupHandlers == null || this.integrationGroupHandlers.isEmpty()) {
            throw new PropertyServerException(IntegrationDaemonServicesErrorCode.NO_INTEGRATION_GROUPS.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        IntegrationGroupHandler handler = this.integrationGroupHandlers.get(integrationGroupName);
        if (handler == null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_GROUP_NAME.getMessageDefinition(new String[]{this.serverName, integrationGroupName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "integrationGroupName");
        }
        handler.refreshConfig();
    }

    IntegrationGroupSummary getIntegrationGroupSummary(String integrationGroupName, String serviceOperationName) throws InvalidParameterException, PropertyServerException {
        String integrationGroupParameterName = "integrationGroupName";
        this.invalidParameterHandler.validateName(integrationGroupName, "integrationGroupName", serviceOperationName);
        if (this.integrationGroupHandlers == null || this.integrationGroupHandlers.isEmpty()) {
            throw new PropertyServerException(IntegrationDaemonServicesErrorCode.NO_INTEGRATION_GROUPS.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        IntegrationGroupHandler handler = this.integrationGroupHandlers.get(integrationGroupName);
        if (handler == null) {
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_GROUP_NAME.getMessageDefinition(new String[]{this.serverName, integrationGroupName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "integrationGroupName");
        }
        return handler.getSummary();
    }

    List<IntegrationGroupSummary> getIntegrationGroupSummaries(String serviceOperationName) throws InvalidParameterException, PropertyServerException {
        if (this.integrationGroupHandlers == null || this.integrationGroupHandlers.isEmpty()) {
            return null;
        }
        ArrayList<IntegrationGroupSummary> summaries = new ArrayList<IntegrationGroupSummary>();
        for (String integrationGroupName : this.integrationGroupHandlers.keySet()) {
            if (integrationGroupName == null) continue;
            summaries.add(this.getIntegrationGroupSummary(integrationGroupName, serviceOperationName));
        }
        if (summaries.isEmpty()) {
            return null;
        }
        return summaries;
    }

    public Map<String, Object> getConfigurationProperties(String connectorName) throws InvalidParameterException {
        String methodName = "getConfigurationProperties";
        String connectorNameParameterName = "connectorName";
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "getConfigurationProperties");
        IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
        if (connectorHandler != null) {
            return connectorHandler.getConfigurationProperties();
        }
        String parameterName = "connectorName";
        String actionDescription = "Retrieve configuration properties";
        throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "Retrieve configuration properties", "connectorName");
    }

    public void updateConfigurationProperties(String userId, String connectorName, boolean isMergeUpdate, Map<String, Object> configurationProperties) throws InvalidParameterException {
        String methodName = "updateConfigurationProperties";
        String connectorNameParameterName = "connectorName";
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "updateConfigurationProperties");
        IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
        if (connectorHandler == null) {
            String actionDescription = "Update connector configuration properties REST API call";
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "Update connector configuration properties REST API call", "connectorName");
        }
        connectorHandler.updateConfigurationProperties(userId, "updateConfigurationProperties", isMergeUpdate, configurationProperties);
    }

    public void updateEndpointNetworkAddress(String userId, String connectorName, String networkAddress) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpointNetworkAddress";
        String connectorNameParameterName = "connectorName";
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "updateEndpointNetworkAddress");
        IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
        if (connectorHandler == null) {
            String actionDescription = "Update connector endpoint network address REST API call";
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "Update connector endpoint network address REST API call", "connectorName");
        }
        connectorHandler.updateEndpointNetworkAddress(userId, "updateEndpointNetworkAddress", networkAddress);
    }

    public void updateConnectorConnection(String userId, String connectorName, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorConnection";
        String connectorNameParameterName = "connectorName";
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "updateConnectorConnection");
        IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
        if (connectorHandler == null) {
            String actionDescription = "Update connector connection REST API call";
            String parameterName = "connectorName";
            throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "Update connector connection REST API call", "connectorName");
        }
        connectorHandler.updateConnectorConnection(userId, "updateConnectorConnection", connection);
    }

    public List<IntegrationConnectorReport> getConnectorReports() {
        ArrayList<IntegrationConnectorReport> connectorReports = new ArrayList<IntegrationConnectorReport>();
        List<String> connectorIds = this.integrationConnectorCacheMap.getConnectorIds();
        for (String connectorId : connectorIds) {
            IntegrationConnectorHandler connectorHandler;
            if (connectorId == null || (connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorId(connectorId)) == null) continue;
            connectorReports.add(connectorHandler.getConnectorReport());
        }
        return connectorReports;
    }

    public void refreshConnector(String connectorName) throws InvalidParameterException {
        String methodName = "refreshConnector";
        if (connectorName == null) {
            List<String> connectorIds = this.integrationConnectorCacheMap.getConnectorIds();
            for (String connectorId : connectorIds) {
                IntegrationConnectorHandler connectorHandler;
                if (connectorId == null || (connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorId(connectorId)) == null) continue;
                connectorHandler.refreshConnector("refreshConnector");
            }
        } else {
            IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
            if (connectorHandler != null) {
                connectorHandler.refreshConnector("refreshConnector");
            } else {
                String parameterName = "connectorName";
                throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "refreshConnector", "connectorName");
            }
        }
    }

    public void restartConnector(String connectorName) throws InvalidParameterException {
        String methodName = "restartConnector";
        if (connectorName == null) {
            for (String connectorId : this.integrationConnectorCacheMap.getConnectorIds()) {
                IntegrationConnectorHandler connectorHandler;
                if (connectorId == null || (connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorId(connectorId)) == null) continue;
                connectorHandler.reinitializeConnector("restartConnector");
            }
        } else {
            IntegrationConnectorHandler connectorHandler = this.integrationConnectorCacheMap.getHandlerByConnectorName(connectorName);
            if (connectorHandler != null) {
                connectorHandler.reinitializeConnector("restartConnector");
            } else {
                String parameterName = "connectorName";
                throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_CONNECTOR_NAME.getMessageDefinition(new String[]{connectorName, this.serverName}), ((Object)((Object)this)).getClass().getName(), "restartConnector", "connectorName");
            }
        }
    }

    public void shutdown() {
        String actionDescription = "Server shutdown";
        if (this.integrationConnectorCacheMap != null && this.integrationConnectorCacheMap.getConnectorIds() != null) {
            for (String connectorId : this.integrationConnectorCacheMap.getConnectorIds()) {
                IntegrationConnectorHandler handler = this.integrationConnectorCacheMap.getHandlerByConnectorId(connectorId);
                if (handler == null) continue;
                handler.shutdown("Server shutdown");
            }
        }
        super.shutdown();
    }
}

