/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.threads;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesAuditCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.handlers.IntegrationConnectorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationConnectorRefreshThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IntegrationConnectorRefreshThread.class);
    private final String integrationDaemonName;
    private final IntegrationConnectorHandler connectorHandler;
    private final AuditLog auditLog;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public IntegrationConnectorRefreshThread(String integrationDaemonName, IntegrationConnectorHandler connectorHandler, AuditLog auditLog) {
        this.integrationDaemonName = integrationDaemonName;
        this.connectorHandler = connectorHandler;
        this.auditLog = auditLog;
    }

    public void start() {
        String threadName = "::IntegrationConnectorRefreshThread:" + this.connectorHandler.getIntegrationConnectorName();
        Thread worker = new Thread((Runnable)this, this.integrationDaemonName + threadName);
        worker.start();
    }

    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        String actionDescription = "Periodic refresh of connector";
        this.running.set(true);
        this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.REFRESH_THREAD_STARTING.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName()}));
        while (this.running.get()) {
            Date now = new Date();
            if ((this.connectorHandler.getStartDate() == null || now.after(this.connectorHandler.getStartDate())) && (this.connectorHandler.getStopDate() == null || now.before(this.connectorHandler.getStopDate()))) {
                try {
                    long nextRefreshTime;
                    Date lastRefreshTime = this.connectorHandler.getLastRefreshTime();
                    long minMinutedBetweenRefresh = this.connectorHandler.getMinMinutesBetweenRefresh();
                    if (lastRefreshTime == null) {
                        this.connectorHandler.refreshConnector("Periodic refresh of connector");
                    } else if (minMinutedBetweenRefresh > 0L && (nextRefreshTime = lastRefreshTime.getTime() + minMinutedBetweenRefresh * 60000L) < now.getTime()) {
                        this.connectorHandler.refreshConnector("Periodic refresh of connector");
                    }
                }
                catch (Exception | NoClassDefFoundError error) {
                    this.auditLog.logException("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.REFRESH_THREAD_CONNECTOR_ERROR.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName(), error.getClass().getName(), error.getMessage()}), error);
                }
            }
            this.waitToRetry();
        }
        this.auditLog.logMessage("Periodic refresh of connector", IntegrationDaemonServicesAuditCode.REFRESH_THREAD_TERMINATING.getMessageDefinition(new String[]{this.connectorHandler.getIntegrationConnectorName()}));
    }

    private void waitToRetry() {
        int sleepTime = 1000;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception error) {
            log.error("Ignored exception from sleep - probably ok", (Throwable)error);
        }
    }
}

