/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/integration-daemon/users/{userId}"})
@Tag(name="Integration Daemon Services", description="The integration daemon services host one or more integration services that support metadata exchange with third party technology.", externalDocs=@ExternalDocumentation(description="Integration Daemon Services", url="https://egeria.odpi.org/open-metadata-implementation/governance-servers/integration-daemon-services/"))
public class IntegrationDaemonResource {
    private IntegrationDaemonRESTServices restAPI = new IntegrationDaemonRESTServices();

    @PostMapping(path={"/refresh"})
    public VoidResponse refreshAllServices(@PathVariable String serverName, @PathVariable String userId, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.refreshAllServices(serverName, userId, requestBody);
    }

    @PostMapping(path={"/integration-service/{serviceURLMarker}/refresh"})
    public VoidResponse refreshService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) String connectorName) {
        return this.restAPI.refreshService(serverName, userId, serviceURLMarker, connectorName);
    }

    @PostMapping(path={"/integration-service/{serviceURLMarker}/restart"})
    public VoidResponse restartService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) String connectorName) {
        return this.restAPI.restartService(serverName, userId, serviceURLMarker, connectorName);
    }

    @PostMapping(path={"/status"})
    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(String serverName, String userId) {
        return this.restAPI.getIntegrationDaemonStatus(serverName, userId);
    }
}

