/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummariesResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationServiceSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/integration-daemon/users/{userId}"})
@Tag(name="Integration Daemon Services", description="The integration daemon services host one or more integration services that support metadata exchange with third party technology.", externalDocs=@ExternalDocumentation(description="Integration Daemon Services", url="https://egeria-project.org/services/integration-daemon-services/"))
public class IntegrationDaemonResource {
    private final IntegrationDaemonRESTServices restAPI = new IntegrationDaemonRESTServices();

    @GetMapping(path={"/integration-services/{serviceURLMarker}/connectors/{connectorName}/configuration-properties"})
    public PropertiesResponse getConfigurationProperties(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @PathVariable String connectorName) {
        return this.restAPI.getConfigurationProperties(serverName, userId, serviceURLMarker, connectorName);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}/connectors/configuration-properties"})
    public VoidResponse updateConfigurationProperties(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody ConnectorConfigPropertiesRequestBody requestBody) {
        return this.restAPI.updateConfigurationProperties(serverName, userId, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/refresh"})
    public VoidResponse refreshAllServices(@PathVariable String serverName, @PathVariable String userId, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.refreshAllServices(serverName, userId, requestBody);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}/refresh"})
    public VoidResponse refreshService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.refreshService(serverName, userId, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}/restart"})
    public VoidResponse restartService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.restartService(serverName, userId, serviceURLMarker, requestBody);
    }

    @GetMapping(path={"/status"})
    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationDaemonStatus(serverName, userId);
    }

    @GetMapping(path={"/integration-services/summary"})
    public IntegrationServiceSummaryResponse getIntegrationServicesSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationServicesSummaries(serverName, userId);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupName}/summary"})
    public IntegrationGroupSummaryResponse getIntegrationGroupSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupName) {
        return this.restAPI.getIntegrationGroupSummary(serverName, userId, integrationGroupName);
    }

    @GetMapping(path={"/integration-groups/summary"})
    public IntegrationGroupSummariesResponse getIntegrationGroupSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationGroupSummaries(serverName, userId);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupName}/refresh-config"})
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupName) {
        return this.restAPI.refreshConfig(serverName, userId, integrationGroupName);
    }
}

