/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationDaemonStatusResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummariesResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationGroupSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.IntegrationServiceSummaryResponse;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/integration-daemon/users/{userId}"})
@Tag(name="Integration Daemon Services", description="The integration daemon services host one or more integration services that support metadata exchange with third party technology.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/integration-daemon-services/"))
public class IntegrationDaemonResource {
    private final IntegrationDaemonRESTServices restAPI = new IntegrationDaemonRESTServices();

    @GetMapping(path={"/status"})
    @Operation(summary="getIntegrationDaemonStatus", description="Return the status of each of the integration services and integration groups running in the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public IntegrationDaemonStatusResponse getIntegrationDaemonStatus(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationDaemonStatus(serverName, userId);
    }

    @GetMapping(path={"/integration-connectors/{connectorName}/configuration-properties"})
    @Operation(summary="getConfigurationProperties", description="Retrieve the configuration properties of the named integration connector running in the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public PropertiesResponse getConfigurationProperties(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorName) {
        return this.restAPI.getConfigurationProperties(serverName, userId, connectorName);
    }

    @PostMapping(path={"/integration-connectors/configuration-properties"})
    @Operation(summary="updateConfigurationProperties", description="Update the configuration properties of the integration connectors, or specific integration connector if a connector name is supplied.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateConfigurationProperties(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConnectorConfigPropertiesRequestBody requestBody) {
        return this.restAPI.updateConfigurationProperties(serverName, userId, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{connectorName}/endpoint-network-address"})
    @Operation(summary="updateEndpointNetworkAddress", description="Update the endpoint network address for a specific integration connector.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateEndpointNetworkAddress(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorName, @RequestBody StringRequestBody requestBody) {
        return this.restAPI.updateEndpointNetworkAddress(serverName, userId, connectorName, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{connectorName}/connection"})
    @Operation(summary="updateConnectorConnection", description="Update the connection for a specific integration connector.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateConnectorConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorName, @RequestBody Connection requestBody) {
        return this.restAPI.updateConnectorConnection(serverName, userId, connectorName, requestBody);
    }

    @PostMapping(path={"/integration-connectors/refresh"})
    @Operation(summary="refreshConnectors", description="Issue a refresh() request on all connectors running in the integration daemon, or a specific connector if the connector name is specified.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse refreshConnectors(@PathVariable String serverName, @PathVariable String userId, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.refreshConnectors(serverName, userId, requestBody);
    }

    @PostMapping(path={"/integration-connectors/restart"})
    @Operation(summary="restartConnectors", description="Restart all connectors running in the integration daemon, or restart a specific connector if the connector name is specified.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse restartConnectors(@PathVariable String serverName, @PathVariable String userId, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.restartConnectors(serverName, userId, requestBody);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}/refresh"})
    @Operation(summary="refreshService", description="Process a refresh request.  This calls refresh on all connectors within the integration service.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse refreshService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.refreshService(serverName, userId, serviceURLMarker, requestBody);
    }

    @PostMapping(path={"/integration-services/{serviceURLMarker}/restart"})
    @Operation(summary="restartService", description="Request that the integration service shutdown and restart its integration connectors.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse restartService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.restartService(serverName, userId, serviceURLMarker, requestBody);
    }

    @GetMapping(path={"/integration-services/summary"})
    @Operation(summary="getIntegrationServicesSummaries", description="Return a summary of each of the integration services' status.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public IntegrationServiceSummaryResponse getIntegrationServicesSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationServicesSummaries(serverName, userId);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupName}/summary"})
    @Operation(summary="getIntegrationGroupSummary", description="Retrieve the description and status of the requested integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public IntegrationGroupSummaryResponse getIntegrationGroupSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupName) {
        return this.restAPI.getIntegrationGroupSummary(serverName, userId, integrationGroupName);
    }

    @GetMapping(path={"/integration-groups/summary"})
    @Operation(summary="getIntegrationGroupSummaries", description="Return a summary of each of the integration groups running in the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public IntegrationGroupSummariesResponse getIntegrationGroupSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getIntegrationGroupSummaries(serverName, userId);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupName}/refresh-config"})
    @Operation(summary="refreshIntegrationGroupConfig", description="Request that the integration group refresh its configuration by calling the metadata access server. Changes to the connector configuration will result in the affected connectors being restarted. This request is useful if the metadata access server has an outage, particularly while the integration daemon is initializing.  This request just ensures that the latest configuration is in use.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse refreshIntegrationGroupConfig(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupName) {
        return this.restAPI.refreshIntegrationGroupConfig(serverName, userId, integrationGroupName);
    }
}

