/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum ITInfrastructureAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-IT-INFRASTRUCTURE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The IT Infrastructure Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the IT Infrastructure OMAS.  This service supports the documentation of the IT infrastructure.", "No action is needed if this service is required.  This is part of the configured operation of the server."),
    SERVICE_INITIALIZED("OMAS-IT-INFRASTRUCTURE-0003", OMRSAuditLogRecordSeverity.STARTUP, "The IT Infrastructure Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that there were no errors reported as the service started."),
    SERVICE_SHUTDOWN("OMAS-IT-INFRASTRUCTURE-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The IT Infrastructure Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an IT Infrastructure OMAS instance.", "Verify that all resources have been released."),
    SERVICE_INSTANCE_FAILURE("OMAS-IT-INFRASTRUCTURE-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The IT Infrastructure Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    AuditLogMessageDefinition messageDefinition;

    private ITInfrastructureAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

