/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.HostProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HostElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private HostProperties properties = null;
    private ElementHeader elementHeader = null;

    public HostElement() {
    }

    public HostElement(HostElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
        }
    }

    public HostElement(AssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            AssetProperties assetProperties = template.getProperties();
            if (assetProperties != null) {
                this.properties = new HostProperties(assetProperties);
            }
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public HostProperties getProperties() {
        return this.properties;
    }

    public void setProperties(HostProperties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "HostElement{properties=" + this.properties + ", elementHeader=" + this.elementHeader + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        HostElement that = (HostElement)objectToCompare;
        return Objects.equals(this.getProperties(), that.getProperties()) && Objects.equals(this.getElementHeader(), that.getElementHeader());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties);
    }
}

