/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.SoftwareServerPlatformProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SoftwareServerPlatformElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private SoftwareServerPlatformProperties properties = null;
    private ElementHeader elementHeader = null;

    public SoftwareServerPlatformElement() {
    }

    public SoftwareServerPlatformElement(SoftwareServerPlatformElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
        }
    }

    public SoftwareServerPlatformElement(AssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            AssetProperties assetProperties = template.getProperties();
            if (assetProperties != null) {
                this.properties = new SoftwareServerPlatformProperties(assetProperties);
            }
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public SoftwareServerPlatformProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SoftwareServerPlatformProperties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "SoftwareServerPlatformElement{properties=" + this.properties + ", elementHeader=" + this.elementHeader + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        SoftwareServerPlatformElement that = (SoftwareServerPlatformElement)objectToCompare;
        return Objects.equals(this.getProperties(), that.getProperties()) && Objects.equals(this.getElementHeader(), that.getElementHeader());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.properties);
    }
}

