/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.ITInfrastructureProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SoftwareServerPlatformProperties
extends ITInfrastructureProperties {
    private static final long serialVersionUID = 1L;
    private static final String deployedImplementationTypeProperty = "deployedImplementationType";
    private static final String versionProperty = "platformVersion";
    private static final String sourceProperty = "source";
    private static final String userIdProperty = "userId";
    private String platformType = null;
    private String platformVersion = null;
    private String platformSource = null;
    private String platformUserId = null;

    public SoftwareServerPlatformProperties() {
    }

    public SoftwareServerPlatformProperties(SoftwareServerPlatformProperties template) {
        super(template);
        if (template != null) {
            this.platformType = template.getSoftwareServerPlatformType();
            this.platformVersion = template.getSoftwareServerPlatformVersion();
            this.platformSource = template.getSoftwareServerPlatformSource();
            this.platformUserId = template.getSoftwareServerPlatformUserId();
        }
    }

    public SoftwareServerPlatformProperties(AssetProperties template) {
        super(template);
        Map<String, Object> assetExtendedProperties;
        if (template != null && (assetExtendedProperties = template.getExtendedProperties()) != null) {
            if (assetExtendedProperties.get(deployedImplementationTypeProperty) != null) {
                this.platformType = assetExtendedProperties.get(deployedImplementationTypeProperty).toString();
                assetExtendedProperties.remove(deployedImplementationTypeProperty);
            }
            if (assetExtendedProperties.get(versionProperty) != null) {
                this.platformVersion = assetExtendedProperties.get(versionProperty).toString();
                assetExtendedProperties.remove(versionProperty);
            }
            if (assetExtendedProperties.get(sourceProperty) != null) {
                this.platformSource = assetExtendedProperties.get(sourceProperty).toString();
                assetExtendedProperties.remove(sourceProperty);
            }
            if (assetExtendedProperties.get(userIdProperty) != null) {
                this.platformUserId = assetExtendedProperties.get(userIdProperty).toString();
                assetExtendedProperties.remove(userIdProperty);
            }
            super.setExtendedProperties(assetExtendedProperties);
        }
    }

    public AssetProperties cloneToAsset() {
        return this.cloneToAsset("SoftwareServerPlatform");
    }

    @Override
    public AssetProperties cloneToAsset(String subTypeName) {
        AssetProperties assetProperties = super.cloneToAsset(subTypeName);
        Map<String, Object> assetExtendedProperties = assetProperties.getExtendedProperties();
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (this.platformType != null) {
            assetExtendedProperties.put(deployedImplementationTypeProperty, this.platformType);
        }
        if (this.platformVersion != null) {
            assetExtendedProperties.put(versionProperty, this.platformVersion);
        }
        if (this.platformSource != null) {
            assetExtendedProperties.put(sourceProperty, this.platformSource);
        }
        if (this.platformUserId != null) {
            assetExtendedProperties.put(userIdProperty, this.platformUserId);
        }
        if (!assetExtendedProperties.isEmpty()) {
            assetProperties.setExtendedProperties(assetExtendedProperties);
        }
        return assetProperties;
    }

    public String getSoftwareServerPlatformType() {
        return this.platformType;
    }

    public void setSoftwareServerPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getSoftwareServerPlatformVersion() {
        return this.platformVersion;
    }

    public void setSoftwareServerPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getSoftwareServerPlatformSource() {
        return this.platformSource;
    }

    public void setSoftwareServerPlatformSource(String platformSource) {
        this.platformSource = platformSource;
    }

    public String getSoftwareServerPlatformUserId() {
        return this.platformUserId;
    }

    public void setSoftwareServerPlatformUserId(String platformUserId) {
        this.platformUserId = platformUserId;
    }

    @Override
    public String toString() {
        return "SoftwareServerPlatformProperties{platformType='" + this.platformType + "', platformVersion='" + this.platformVersion + "', platformSource='" + this.platformSource + "', platformUserId='" + this.platformUserId + "', displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SoftwareServerPlatformProperties that = (SoftwareServerPlatformProperties)objectToCompare;
        return Objects.equals(this.platformType, that.platformType) && Objects.equals(this.platformVersion, that.platformVersion) && Objects.equals(this.platformSource, that.platformSource) && Objects.equals(this.platformUserId, that.platformUserId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.platformType, this.platformVersion, this.platformSource, this.platformUserId);
    }
}

