/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.itinfrastructure.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.itinfrastructure.metadataelements.ElementStatus;
import org.odpi.openmetadata.accessservices.itinfrastructure.properties.AssetProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementStatusRequestBody
extends AssetProperties {
    private static final long serialVersionUID = 1L;
    private String externalSourceGUID = null;
    private String externalSourceName = null;
    private ElementStatus elementStatus = null;

    public ElementStatusRequestBody() {
    }

    public ElementStatusRequestBody(ElementStatusRequestBody template) {
        super(template);
        if (template != null) {
            this.externalSourceGUID = template.getExternalSourceGUID();
            this.externalSourceName = template.getExternalSourceName();
        }
    }

    public ElementStatusRequestBody(AssetProperties template) {
        super(template);
    }

    public String getExternalSourceGUID() {
        return this.externalSourceGUID;
    }

    public void setExternalSourceGUID(String externalSourceGUID) {
        this.externalSourceGUID = externalSourceGUID;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    public ElementStatus getElementStatus() {
        return this.elementStatus;
    }

    public void setElementStatus(ElementStatus elementStatus) {
        this.elementStatus = elementStatus;
    }

    @Override
    public String toString() {
        return "ElementStatusRequestBody{externalSourceGUID='" + this.externalSourceGUID + "', externalSourceName='" + this.externalSourceName + "', initialStatus=" + this.elementStatus + ", displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ElementStatusRequestBody that = (ElementStatusRequestBody)objectToCompare;
        return Objects.equals(this.externalSourceGUID, that.externalSourceGUID) && Objects.equals(this.externalSourceName, that.externalSourceName) && this.elementStatus == that.elementStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalSourceGUID, this.externalSourceName, this.elementStatus);
    }
}

